/*
 * Decompiled with CFR 0.152.
 */
package dev.penguinspy.thinner_air.airquality;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.penguinspy.thinner_air.AirSettingsDefinition;
import dev.penguinspy.thinner_air.AirSettingsWorld;
import dev.penguinspy.thinner_air.ThinnerAir;
import dev.penguinspy.thinner_air.airquality.AirQuality;
import dev.penguinspy.thinner_air.airquality.AirQualityEmittersComponent;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1292;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_6862;

public final class AirQualityUtil {
    public static final int SEARCH_RADIUS = 1;

    private AirQualityUtil() {
    }

    public static AirQuality getEffectiveAirQuality(class_1309 entity) {
        block11: {
            block10: {
                if (class_1292.method_5574((class_1309)entity)) break block10;
                if (!(entity instanceof class_1657)) break block11;
                class_1657 player = (class_1657)entity;
                if (!player.method_31549().field_7480) break block11;
            }
            return AirQuality.GREEN;
        }
        AirQuality quality = AirQualityUtil.getAirQualityAtEntity((class_1297)entity);
        class_3545<class_1799, Object> breathingEquipmentPair = AirQualityUtil.getEquipment(entity, ThinnerAir.BREATHING_EQUIPMENT);
        class_1799 breathingEquipment = (class_1799)breathingEquipmentPair.method_15442();
        if (quality == AirQuality.YELLOW && !breathingEquipment.method_7960()) {
            if (entity.method_37908().method_8510() % 240L == 0L) {
                AirQualityUtil.damageEquipment(breathingEquipment, breathingEquipmentPair.method_15441(), entity);
            }
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                ThinnerAir.BREATHE_AIR.trigger(player, quality, true);
            }
            return AirQuality.GREEN;
        }
        class_3545<class_1799, Object> heavyBreathingEquipmentPair = AirQualityUtil.getEquipment(entity, ThinnerAir.HEAVY_BREATHING_EQUIPMENT);
        class_1799 heavyBreathingEquipment = (class_1799)heavyBreathingEquipmentPair.method_15442();
        if (quality == AirQuality.RED && !heavyBreathingEquipment.method_7960()) {
            if (entity.method_37908().method_8510() % 240L == 0L) {
                AirQualityUtil.damageEquipment(heavyBreathingEquipment, heavyBreathingEquipmentPair.method_15441(), entity);
            }
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                ThinnerAir.BREATHE_AIR.trigger(player, quality, true);
            }
            return AirQuality.GREEN;
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            ThinnerAir.BREATHE_AIR.trigger(player, quality, false);
        }
        return quality;
    }

    public static AirQuality getAirQualityAtEntity(class_1297 entity) {
        class_243 position = entity.method_19538().method_1031(0.0, (double)entity.method_18381(entity.method_18376()), 0.0);
        return AirQualityUtil.getAirQualityAtPos(entity.method_37908(), position);
    }

    public static AirQuality getAirQualityAtPos(class_1937 world, class_243 position) {
        AirSettingsDefinition airSettings = ((AirSettingsWorld)world).getAirSettings();
        AirQuality bestAirQuality = null;
        class_1923 centerChunkPos = new class_1923(class_2338.method_49638((class_2374)position));
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2818 chunk = world.method_8497(centerChunkPos.field_9181 + x, centerChunkPos.field_9180 + z);
                AirQualityEmittersComponent component = (AirQualityEmittersComponent)ThinnerAir.AIR_QUALITY_EMITTERS.getNullable((Object)chunk);
                if (component == null) continue;
                for (Map.Entry<class_2338, AirQuality> entry : component.getAirQualityEmitters().entrySet()) {
                    double distance;
                    double emitterRadius;
                    class_2338 blockPos = entry.getKey();
                    AirQuality quality = entry.getValue();
                    switch (quality) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case GREEN: {
                            double d = airSettings.greenAirEmittersRadius();
                            break;
                        }
                        case YELLOW: {
                            double d = airSettings.yellowAirEmittersRadius();
                            break;
                        }
                        case RED: {
                            double d = airSettings.redAirEmittersRadius();
                            break;
                        }
                        case BLUE: {
                            double d = emitterRadius = airSettings.blueAirEmittersRadius();
                        }
                    }
                    if (!((distance = position.method_1028((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5)) <= emitterRadius) || (bestAirQuality = AirQuality.bestOf(quality, bestAirQuality)) != AirQuality.GREEN) continue;
                    return bestAirQuality;
                }
            }
        }
        if (bestAirQuality != null) {
            return bestAirQuality;
        }
        for (AirSettingsDefinition.AirSettingsSectionDefinition section : airSettings.sections()) {
            if (!(position.field_1351 > (double)section.minY()) || !(position.field_1351 < (double)section.maxY())) continue;
            return section.quality();
        }
        return airSettings.defaultAirQuality();
    }

    public static class_3545<class_1799, Object> getEquipment(class_1309 entity, class_6862<class_1792> tag) {
        class_1799 helmet;
        Optional component = TrinketsApi.getTrinketComponent((class_1309)entity);
        if (component.isPresent()) {
            for (Map inventories : ((TrinketComponent)component.get()).getInventory().values()) {
                for (TrinketInventory inventory : inventories.values()) {
                    for (int i = 0; i < inventory.method_5439(); ++i) {
                        class_1799 stack = inventory.method_5438(i);
                        if (!stack.method_31573(tag)) continue;
                        return new class_3545((Object)stack, (Object)new SlotReference(inventory, i));
                    }
                }
            }
        }
        if ((helmet = entity.method_6118(class_1304.field_6169)).method_31573(tag)) {
            return new class_3545((Object)helmet, (Object)class_1304.field_6169);
        }
        return new class_3545((Object)class_1799.field_8037, null);
    }

    public static void damageEquipment(class_1799 equipment, Object slot, class_1309 entity) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3222 serverPlayerEntity;
            class_3218 serverWorld = (class_3218)class_19372;
            equipment.method_7956(1, serverWorld, entity instanceof class_3222 ? (serverPlayerEntity = (class_3222)entity) : null, item -> {
                if (slot instanceof SlotReference) {
                    SlotReference slotReference = (SlotReference)slot;
                    TrinketsApi.onTrinketBroken((class_1799)equipment, (SlotReference)slotReference, (class_1309)entity);
                } else if (slot instanceof class_1304) {
                    class_1304 equipmentSlot = (class_1304)slot;
                    entity.method_20235(item, equipmentSlot);
                }
            });
        }
    }
}

