/*
 * Decompiled with CFR 0.152.
 */
package dev.penguinspy.thinner_air;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.OptionalFieldCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.penguinspy.thinner_air.ThinnerAir;
import dev.penguinspy.thinner_air.airquality.AirQuality;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2874;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public record AirSettingsDefinition(AirQuality defaultAirQuality, List<AirSettingsSectionDefinition> sections, class_6862<class_2248> greenAirEmitters, double greenAirEmittersRadius, class_6862<class_2248> yellowAirEmitters, double yellowAirEmittersRadius, class_6862<class_2248> redAirEmitters, double redAirEmittersRadius, class_6862<class_2248> blueAirEmitters, double blueAirEmittersRadius) {
    public static final double MAX_RADIUS = 16.0;
    public static final Codec<AirSettingsDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AirQuality.CODEC.fieldOf("default_air_quality").forGetter(AirSettingsDefinition::defaultAirQuality), (App)AirSettingsSectionDefinition.CODEC.listOf().fieldOf("sections").forGetter(AirSettingsDefinition::sections), (App)class_6862.method_40093((class_5321)class_7924.field_41254).optionalFieldOf("green_air_emitters", ThinnerAir.GREEN_AIR_EMITTERS).forGetter(AirSettingsDefinition::greenAirEmitters), (App)AirSettingsDefinition.optionalRadiusField((Codec<Double>)Codec.doubleRange((double)0.0, (double)16.0), "green_air_emitters_radius", () -> ThinnerAir.config.greenAirEmittersRadius).forGetter(AirSettingsDefinition::greenAirEmittersRadius), (App)class_6862.method_40093((class_5321)class_7924.field_41254).optionalFieldOf("yellow_air_emitters", ThinnerAir.YELLOW_AIR_EMITTERS).forGetter(AirSettingsDefinition::yellowAirEmitters), (App)AirSettingsDefinition.optionalRadiusField((Codec<Double>)Codec.doubleRange((double)0.0, (double)16.0), "yellow_air_emitters_radius", () -> ThinnerAir.config.yellowAirEmittersRadius).forGetter(AirSettingsDefinition::yellowAirEmittersRadius), (App)class_6862.method_40093((class_5321)class_7924.field_41254).optionalFieldOf("red_air_emitters", ThinnerAir.RED_AIR_EMITTERS).forGetter(AirSettingsDefinition::redAirEmitters), (App)AirSettingsDefinition.optionalRadiusField((Codec<Double>)Codec.doubleRange((double)0.0, (double)16.0), "red_air_emitters_radius", () -> ThinnerAir.config.redAirEmittersRadius).forGetter(AirSettingsDefinition::redAirEmittersRadius), (App)class_6862.method_40093((class_5321)class_7924.field_41254).optionalFieldOf("blue_air_emitters", ThinnerAir.BLUE_AIR_EMITTERS).forGetter(AirSettingsDefinition::blueAirEmitters), (App)AirSettingsDefinition.optionalRadiusField((Codec<Double>)Codec.doubleRange((double)0.0, (double)16.0), "blue_air_emitters_radius", () -> ThinnerAir.config.blueAirEmittersRadius).forGetter(AirSettingsDefinition::blueAirEmittersRadius)).apply((Applicative)instance, AirSettingsDefinition::new));

    private static MapCodec<Double> optionalRadiusField(Codec<Double> elementCodec, String name, Supplier<Double> defaultSupplier) {
        return new OptionalFieldCodec(name, elementCodec, false).xmap(o -> Math.pow(o.orElse((Double)defaultSupplier.get()), 2.0), a -> Optional.of(Math.sqrt(a)));
    }

    public record AirSettingsSectionDefinition(AirQuality quality, int minY, int maxY) {
        public static final Codec<AirSettingsSectionDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AirQuality.CODEC.fieldOf("quality").forGetter(AirSettingsSectionDefinition::quality), (App)Codec.intRange((int)class_2874.field_28136, (int)class_2874.field_28135).fieldOf("min_y").forGetter(AirSettingsSectionDefinition::minY), (App)Codec.intRange((int)class_2874.field_28136, (int)class_2874.field_28135).fieldOf("max_y").forGetter(AirSettingsSectionDefinition::maxY)).apply((Applicative)instance, AirSettingsSectionDefinition::new));
    }
}

