/*
 * Decompiled with CFR 0.152.
 */
package dev.penguinspy.thinner_air;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.penguinspy.thinner_air.ThinnerAir;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ThinnerAirConfig {
    public static final double DEFAULT_GREEN_AIR_EMITTER_RADIUS = 8.0;
    public static final double DEFAULT_YELLOW_AIR_EMITTER_RADIUS = 8.0;
    public static final double DEFAULT_RED_AIR_EMITTER_RADIUS = 2.5;
    public static final double DEFAULT_BLUE_AIR_EMITTER_RADIUS = 6.0;
    public double greenAirEmittersRadius = 8.0;
    public double yellowAirEmittersRadius = 8.0;
    public double redAirEmittersRadius = 2.5;
    public double blueAirEmittersRadius = 6.0;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2, 8}).create();

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("thinner_air.json");
    }

    public static ThinnerAirConfig loadConfig() {
        Path path = ThinnerAirConfig.getConfigPath();
        ThinnerAirConfig config = null;
        if (Files.exists(path, new LinkOption[0])) {
            try (FileReader reader = new FileReader(path.toFile());){
                config = (ThinnerAirConfig)GSON.fromJson((Reader)reader, ThinnerAirConfig.class);
            }
            catch (IOException e) {
                ThinnerAir.LOGGER.error("failed to read config file, using default config", (Throwable)e);
            }
        } else {
            ThinnerAir.LOGGER.info("config file not found, using default config");
        }
        if (config == null) {
            config = new ThinnerAirConfig();
        }
        ThinnerAirConfig.saveConfig(config);
        return config;
    }

    public static void saveConfig(ThinnerAirConfig config) {
        try (FileWriter writer = new FileWriter(ThinnerAirConfig.getConfigPath().toFile());){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            ThinnerAir.LOGGER.error("failed to save config file!", (Throwable)e);
        }
    }
}

