/*
 * Decompiled with CFR 0.152.
 */
package dev.penguinspy.thinner_air.airquality;

import dev.penguinspy.thinner_air.airquality.AirQuality;
import dev.penguinspy.thinner_air.airquality.AirQualityEmittersComponent;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.impl.serialization.SpecialCodecs;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2791;

public class AirQualityEmittersComponentImplementation
implements AirQualityEmittersComponent {
    private static final String EMITTERS_MAP_KEY = "emitters";
    private final Map<class_2338, AirQuality> airQualityEmitters = new HashMap<class_2338, AirQuality>();
    private final class_2791 chunk;

    public AirQualityEmittersComponentImplementation(class_2791 provider) {
        this.chunk = provider;
    }

    @Override
    public void put(class_2338 pos, AirQuality quality) {
        this.airQualityEmitters.put(pos, quality);
        this.chunk.method_65063();
    }

    @Override
    public void remove(class_2338 pos) {
        if (this.airQualityEmitters.remove(pos) != null) {
            this.chunk.method_65063();
        }
    }

    @Override
    public Map<class_2338, AirQuality> getAirQualityEmitters() {
        return this.airQualityEmitters;
    }

    public void readData(class_11368 readView) {
        this.airQualityEmitters.clear();
        Optional byteArray = readView.method_71426(EMITTERS_MAP_KEY, SpecialCodecs.BYTE_ARRAY);
        if (byteArray.isEmpty()) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap((byte[])byteArray.get());
        while (buffer.hasRemaining()) {
            class_2338 position = class_2338.method_10092((long)buffer.getLong());
            AirQuality quality = AirQuality.fromLevel(buffer.get());
            this.airQualityEmitters.put(position, quality);
        }
    }

    public void writeData(class_11372 writeView) {
        ByteBuffer buffer = ByteBuffer.allocate(this.airQualityEmitters.size() * 9);
        for (Map.Entry<class_2338, AirQuality> entry : this.airQualityEmitters.entrySet()) {
            buffer.putLong(entry.getKey().method_10063());
            buffer.put((byte)entry.getValue().level());
        }
        writeView.putByteArray(EMITTERS_MAP_KEY, buffer.array());
    }
}

