/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.composer_reloaded;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2960;
import org.lilbrocodes.composer_reloaded.api.registry.ComposerRegistries;
import org.lilbrocodes.composer_reloaded.api.util.AdvancementManager;
import org.lilbrocodes.composer_reloaded.client.config.ComposerConfig;
import org.lilbrocodes.composer_reloaded.common.networking.TargetBlockPayload;
import org.lilbrocodes.composer_reloaded.common.networking.TargetEntityPayload;
import org.lilbrocodes.composer_reloaded.common.registry.ComposerBlockEntities;
import org.lilbrocodes.composer_reloaded.common.registry.ComposerBlocks;
import org.lilbrocodes.composer_reloaded.common.registry.ComposerItemGroups;
import org.lilbrocodes.composer_reloaded.common.registry.ComposerSounds;
import org.lilbrocodes.composer_reloaded.common.registry.ComposerStatistics;

public class ComposerReloaded
implements ModInitializer {
    public static final String MOD_ID = "composer_reloaded";
    public static final class_2960 TARGET_ENTITY = ComposerReloaded.identify("target_entity_c2s");
    public static final class_2960 TARGET_BLOCK = ComposerReloaded.identify("target_block_c2s");
    private static boolean dupedKeybindsEnabled = false;

    public void onInitialize() {
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata meta = mod.getMetadata();
            if (meta.getId().equals("enchancement")) {
                dupedKeybindsEnabled = false;
                break;
            }
            CustomValue section = meta.getCustomValue("composer-duped-keybinds");
            if (section == null || section.getType() != CustomValue.CvType.BOOLEAN || !section.getAsBoolean()) continue;
            dupedKeybindsEnabled = true;
        }
        ComposerBlockEntities.initialize();
        ComposerStatistics.initialize();
        ComposerItemGroups.initialize();
        ComposerBlocks.initialize();
        ComposerSounds.initialize();
        ComposerConfig.initialize();
        ComposerRegistries.initialize();
        TargetEntityPayload.registerHandler();
        TargetBlockPayload.registerHandler();
        ServerTickEvents.END_WORLD_TICK.register(AdvancementManager::tick);
    }

    public static boolean dupedBinds() {
        return dupedKeybindsEnabled;
    }

    public static class_2960 identify(String name) {
        return new class_2960(MOD_ID, name);
    }
}

