/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.composer_reloaded.api.velora.emitter;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import org.lilbrocodes.composer_reloaded.api.util.Vec2;
import org.lilbrocodes.composer_reloaded.api.velora.VeloraParticleManager;
import org.lilbrocodes.composer_reloaded.api.velora.particle.VeloraParticle;

public class BurstParticleEmitter {
    private final boolean staggered;
    private final int staggerDelay;
    private final double spread;
    private final int burstAmount;
    private final Function<Vec2, VeloraParticle> particleSupplier;
    private final List<StaggeredBurst> spawnCounters = new ArrayList<StaggeredBurst>();

    private BurstParticleEmitter(Builder builder) {
        this.burstAmount = builder.burstAmount;
        this.particleSupplier = builder.particleSupplier;
        this.staggered = builder.staggered;
        this.staggerDelay = builder.staggerDelay;
        this.spread = builder.spread;
    }

    public void trigger(Vec2 origin) {
        if (this.staggered) {
            this.spawnCounters.add(new StaggeredBurst(System.currentTimeMillis(), this.burstAmount, origin.copy()));
            return;
        }
        this.spawnParticles(origin);
    }

    public void tick(Vec2 origin) {
        ArrayList<Integer> rem = new ArrayList<Integer>();
        VeloraParticleManager manager = VeloraParticleManager.getInstance();
        for (int i2 = 0; i2 < this.spawnCounters.size(); ++i2) {
            StaggeredBurst burst = this.spawnCounters.get(i2);
            if (System.currentTimeMillis() - burst.lastSpawnTime() <= (long)this.staggerDelay) continue;
            this.spawnParticle(manager, burst.origin());
            if (burst.remaining() <= 1) {
                rem.add(i2);
                continue;
            }
            this.spawnCounters.set(i2, new StaggeredBurst(System.currentTimeMillis(), burst.remaining() - 1, burst.origin()));
        }
        rem.forEach(i -> this.spawnCounters.remove((int)i));
    }

    private void spawnParticles(Vec2 origin) {
        VeloraParticleManager manager = VeloraParticleManager.getInstance();
        for (int i = 0; i < this.burstAmount; ++i) {
            this.spawnParticle(manager, origin);
        }
    }

    private void spawnParticle(VeloraParticleManager manager, Vec2 origin) {
        Vec2 spawnPos = origin.copy();
        Random random = new Random();
        if (this.spread > 0.0) {
            double angle = random.nextDouble() * Math.PI * 2.0;
            double radius = Math.sqrt(random.nextDouble()) * this.spread;
            double offsetX = Math.cos(angle) * radius;
            double offsetY = Math.sin(angle) * radius;
            spawnPos = origin.copy().add(new Vec2((float)offsetX, (float)offsetY));
        }
        manager.spawnParticle(spawnPos, this.particleSupplier.apply(spawnPos));
    }

    public static Builder builder(Function<Vec2, VeloraParticle> supplier) {
        return new Builder(supplier);
    }

    public static class Builder {
        private final Function<Vec2, VeloraParticle> particleSupplier;
        private int burstAmount = 0;
        private boolean staggered = false;
        private int staggerDelay = 100;
        private double spread = 0.0;

        private Builder(Function<Vec2, VeloraParticle> supplier) {
            this.particleSupplier = supplier;
        }

        public Builder burstAmount(int amount) {
            this.burstAmount = amount;
            return this;
        }

        public BurstParticleEmitter build() {
            return new BurstParticleEmitter(this);
        }

        public Builder staggered() {
            this.staggered = true;
            return this;
        }

        public Builder staggerTicks(int ticks) {
            this.staggerDelay = 50 * ticks;
            return this;
        }

        public Builder staggerMs(int ms) {
            this.staggerDelay = ms;
            return this;
        }

        public Builder spread(double n) {
            this.spread = n;
            return this;
        }
    }

    private record StaggeredBurst(long lastSpawnTime, int remaining, Vec2 origin) {
    }
}

