/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.composer_reloaded.api.velora;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_332;
import org.jetbrains.annotations.ApiStatus;
import org.lilbrocodes.composer_reloaded.api.util.Vec2;
import org.lilbrocodes.composer_reloaded.api.velora.particle.VeloraParticle;

public class VeloraParticleManager {
    private static VeloraParticleManager INSTANCE;
    private final List<ParticleEntry<?>> aliveParticles = new ArrayList();

    private VeloraParticleManager() {
    }

    public static VeloraParticleManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new VeloraParticleManager();
        }
        return INSTANCE;
    }

    public <T extends VeloraParticle> T spawnParticle(Vec2 origin, T particle) {
        this.aliveParticles.add(new ParticleEntry<T>(particle, origin, System.currentTimeMillis()));
        return particle;
    }

    @ApiStatus.Internal
    public void tick(class_332 ctx) {
        Iterator<ParticleEntry<?>> iterator = this.aliveParticles.iterator();
        while (iterator.hasNext()) {
            ParticleEntry<?> particle = iterator.next();
            long passedTime = System.currentTimeMillis() - particle.creationDate;
            if ((double)passedTime > ((VeloraParticle)particle.particle).lifetimeSeconds * 1000.0) {
                iterator.remove();
                continue;
            }
            ((VeloraParticle)particle.particle).render(ctx, particle.origin);
        }
    }

    @ApiStatus.Internal
    private record ParticleEntry<E extends VeloraParticle>(E particle, Vec2 origin, Long creationDate) {
    }
}

