/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.composer_reloaded.api.velora.particle;

import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.lilbrocodes.composer_reloaded.api.util.Math;
import org.lilbrocodes.composer_reloaded.api.util.Vec2;
import org.lilbrocodes.composer_reloaded.api.velora.particle.SimpleParticle;
import org.lilbrocodes.composer_reloaded.client.render.ParticleRenderer;

public class TexturedParticle
extends SimpleParticle {
    public final class_2960 texture;
    public final int frameCount;
    public final double frameDurationSeconds;

    public TexturedParticle(class_2960 texture, double lifeTimeSeconds, double startSize, double endSize, int startColor, int endColor, double startRotation, double endRotation, Vec2 startVelocity, Vec2 endVelocity, int frameCount, double frameDurationSeconds) {
        super(null, lifeTimeSeconds, startSize, endSize, startColor, endColor, startRotation, endRotation, startVelocity, endVelocity);
        this.texture = texture;
        this.frameCount = frameCount;
        this.frameDurationSeconds = frameDurationSeconds;
    }

    public TexturedParticle(class_2960 texture, double lifeTimeSeconds, double startSize, double endSize, int startColor, int endColor, double startRotation, double endRotation, Vec2 startVelocity, Vec2 endVelocity) {
        this(texture, lifeTimeSeconds, startSize, endSize, startColor, endColor, startRotation, endRotation, startVelocity, endVelocity, 1, 1.0);
    }

    @Override
    public void render(class_332 ctx, Vec2 origin) {
        double age = (double)(System.currentTimeMillis() - this.creationTime) / 1000.0;
        double t = java.lang.Math.min(java.lang.Math.max(age / this.lifetimeSeconds, 0.0), 1.0);
        double size = Math.lerp(this.startSize, this.endSize, t);
        double rotation = Math.lerp(this.startRotation, this.endRotation, t);
        int color = Math.lerpColor(this.startColor, this.endColor, t);
        Vec2 velocity = Math.lerpVec2(this.startVelocity, this.endVelocity, t);
        Vec2 position = new Vec2(origin.x + velocity.x * age, origin.y + velocity.y * age);
        if (this.frameCount > 1) {
            int currentFrame = (int)(age / this.frameDurationSeconds % (double)this.frameCount);
            ParticleRenderer.renderAnimatedQuad(this.texture, position, size, rotation, color, currentFrame, this.frameCount);
        } else {
            ParticleRenderer.renderTexturedQuad(this.texture, position, size, rotation, color);
        }
    }
}

