/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.composer_reloaded.api.toast;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.joml.Vector2i;
import org.lilbrocodes.composer_reloaded.api.render.ColorProgram;
import org.lilbrocodes.composer_reloaded.api.render.ToastDrawUtils;
import org.lilbrocodes.composer_reloaded.api.toast.AbstractToast;

public class SimpleToast
extends AbstractToast {
    private final class_2960 iconTexture;
    private final String message;
    private final int backgroundColor;
    private final int borderColor;
    private final ColorProgram backgroundColorProgram;
    private final ColorProgram borderColorProgram;
    private static final int HEIGHT = 40;
    private static final int MAX_WIDTH = 200;
    private static final int ICON_SIZE = 30;
    private static final long DURATION = 3000L;
    private static final long FADE_TIME = 500L;
    private static final int MARGIN = 50;

    public SimpleToast(class_2960 iconTexture, String message, int backgroundColor, int borderColor) {
        this.iconTexture = iconTexture;
        this.message = message;
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
        this.backgroundColorProgram = null;
        this.borderColorProgram = null;
    }

    public SimpleToast(class_2960 iconTexture, String message, ColorProgram backgroundColorProgram, ColorProgram borderColorProgram) {
        this.iconTexture = iconTexture;
        this.message = message;
        this.backgroundColorProgram = backgroundColorProgram;
        this.borderColorProgram = borderColorProgram;
        this.backgroundColor = -1;
        this.borderColor = -1;
    }

    @Override
    protected void draw(class_332 context, long timeAlive, int x, int y) {
        float scaleX = this.getHorizontalScaleFactor(timeAlive);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)x, (float)y, 0.0f);
        context.method_51448().method_22905(scaleX, 1.0f, 1.0f);
        this.drawBox(context);
        this.drawText(context);
        this.drawIcon(context);
        context.method_51448().method_22909();
        if (timeAlive >= 3000L) {
            this.remove();
        }
    }

    @Override
    protected Vector2i size() {
        return new Vector2i(200, 40);
    }

    @Override
    protected int margin() {
        return 50;
    }

    private void drawIcon(class_332 ctx) {
        int x = -105;
        int y = -15;
        ctx.method_25290(this.iconTexture, x, y, 0.0f, 0.0f, 30, 30, 30, 30);
    }

    private void drawBox(class_332 ctx) {
        ToastDrawUtils.drawCenteredBox(ctx, 0, 0, 200, 40, this.backgroundColorProgram == null ? this.backgroundColor : this.backgroundColorProgram.pick());
        ToastDrawUtils.drawCenteredOutline(ctx, 0, 0, 200, 40, this.borderColorProgram == null ? this.borderColor : this.borderColorProgram.pick(), 1);
    }

    private void drawText(class_332 ctx) {
        int wrapWidth = Math.max(10, 180);
        List lines = this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)this.message), wrapWidth);
        int wrappedHeight = this.textRenderer.method_44378((class_5348)class_2561.method_43470((String)this.message), wrapWidth);
        ToastDrawUtils.drawCenteredLines(ctx, this.textRenderer, lines, 6, 0, wrappedHeight, -1);
    }

    private float getHorizontalScaleFactor(long timeAlive) {
        if (timeAlive < 500L) {
            float t = (float)timeAlive / 500.0f;
            return 1.0f - (float)Math.pow(1.0f - t, 3.0);
        }
        if (timeAlive > 2500L) {
            float t = (float)(timeAlive - 2500L) / 500.0f;
            return 1.0f - (1.0f - (float)Math.pow(1.0f - t, 3.0));
        }
        return 1.0f;
    }
}

