/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.composer_reloaded.api.velora.emitter;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.lilbrocodes.composer_reloaded.api.util.Vec2;
import org.lilbrocodes.composer_reloaded.api.velora.emitter.BurstParticleEmitter;

public class BurstEmitterGroup {
    private final Map<UUID, EmitterEntry<?>> emitters = new HashMap();

    public <T extends BurstParticleEmitter> UUID addEmitter(UUID uuid, Vec2 position, T emitter) {
        this.emitters.put(uuid, new EmitterEntry<T>(position, emitter));
        return uuid;
    }

    public <T extends BurstParticleEmitter> UUID addEmitter(Vec2 position, T emitter) {
        return this.addEmitter(UUID.randomUUID(), position, emitter);
    }

    public void tick() {
        for (EmitterEntry<?> emitter : this.emitters.values()) {
            ((BurstParticleEmitter)emitter.emitter).tick(emitter.pos);
        }
    }

    public void trigger(UUID id) {
        EmitterEntry<?> entry = this.emitters.get(id);
        if (entry == null) {
            return;
        }
        ((BurstParticleEmitter)entry.emitter).trigger(entry.pos);
    }

    public void move(UUID id, Vec2 pos) {
        EmitterEntry<?> entry = this.emitters.get(id);
        if (entry == null) {
            return;
        }
        this.emitters.put(id, new EmitterEntry(pos, entry.emitter));
    }

    private record EmitterEntry<E extends BurstParticleEmitter>(Vec2 pos, E emitter) {
    }
}

