/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.composer_reloaded.api.velora.emitter;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.lilbrocodes.composer_reloaded.api.util.Vec2;
import org.lilbrocodes.composer_reloaded.api.velora.emitter.ContinuousParticleEmitter;

public class ContinuousEmitterGroup {
    private final Map<UUID, EmitterEntry<?>> emitters = new HashMap();

    public <T extends ContinuousParticleEmitter> UUID addEmitter(UUID uuid, Vec2 position, T emitter) {
        this.emitters.put(uuid, new EmitterEntry<T>(position, emitter));
        return uuid;
    }

    public <T extends ContinuousParticleEmitter> UUID addEmitter(Vec2 position, T emitter) {
        return this.addEmitter(UUID.randomUUID(), position, emitter);
    }

    public void tick() {
        for (EmitterEntry<?> entry : this.emitters.values()) {
            ((ContinuousParticleEmitter)entry.emitter).tick(entry.pos);
        }
    }

    public void move(UUID id, Vec2 pos) {
        EmitterEntry<?> entry = this.emitters.get(id);
        if (entry == null) {
            return;
        }
        this.emitters.put(id, new EmitterEntry(pos, entry.emitter));
    }

    private void toggle(UUID id, boolean bl) {
        EmitterEntry<?> entry = this.emitters.get(id);
        if (entry == null) {
            return;
        }
        ((ContinuousParticleEmitter)entry.emitter).toggle(bl);
    }

    public void enable(UUID id) {
        this.toggle(id, true);
    }

    public void disable(UUID id) {
        this.toggle(id, false);
    }

    private record EmitterEntry<E extends ContinuousParticleEmitter>(Vec2 pos, E emitter) {
    }
}

