/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.composer_reloaded.api.velora.particle;

import net.minecraft.class_332;
import org.lilbrocodes.composer_reloaded.api.util.Math;
import org.lilbrocodes.composer_reloaded.api.util.Vec2;
import org.lilbrocodes.composer_reloaded.api.velora.particle.VeloraParticle;
import org.lilbrocodes.composer_reloaded.render.ParticleRenderer;

public class SimpleParticle
extends VeloraParticle {
    public final VeloraParticle.ParticleShape shape;
    public final double startSize;
    public final double endSize;
    public final int startColor;
    public final int endColor;
    public final double startRotation;
    public final double endRotation;
    public final Vec2 startVelocity;
    public final Vec2 endVelocity;
    protected final long creationTime;
    private Vec2 pos;

    public SimpleParticle(VeloraParticle.ParticleShape shape, double lifeTimeSeconds, double startSize, double endSize, int startColor, int endColor, double startRotation, double endRotation, Vec2 startVelocity, Vec2 endVelocity) {
        super(lifeTimeSeconds);
        this.shape = shape;
        this.startSize = startSize;
        this.endSize = endSize;
        this.startColor = startColor;
        this.endColor = endColor;
        this.startRotation = startRotation;
        this.endRotation = endRotation;
        this.startVelocity = startVelocity;
        this.endVelocity = endVelocity;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public void render(class_332 ctx, Vec2 origin) {
        if (this.pos == null) {
            this.pos = origin.copy();
        }
        double elapsedSeconds = (double)(System.currentTimeMillis() - this.creationTime) / 1000.0;
        double t = java.lang.Math.min(1.0, elapsedSeconds / this.lifetimeSeconds);
        double size = Math.lerp(this.startSize, this.endSize, t);
        double rotation = Math.lerp(this.startRotation, this.endRotation, t);
        int color = Math.lerpColor(this.startColor, this.endColor, t);
        Vec2 velocity = Math.lerpVec2(this.startVelocity, this.endVelocity, t);
        this.pos.add(velocity.x * elapsedSeconds, velocity.y * elapsedSeconds);
        ParticleRenderer.renderShape(this.shape, this.pos, size, rotation, color);
    }
}

