/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.composer_reloaded.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_757;
import org.lilbrocodes.composer_reloaded.api.util.Vec2;
import org.lilbrocodes.composer_reloaded.api.velora.particle.VeloraParticle;

public class ParticleRenderer {
    public static void renderShape(VeloraParticle.ParticleShape shape, Vec2 position, double size, double rotation, int color) {
        switch (shape) {
            case CIRCLE: {
                ParticleRenderer.renderCircle(position, size, color);
                break;
            }
            case QUAD: {
                ParticleRenderer.renderQuad(position, size, rotation, color);
                break;
            }
            case TRIANGLE: {
                ParticleRenderer.renderTriangle(position, size, rotation, color);
            }
        }
    }

    private static void renderCircle(Vec2 center, double radius, int color) {
        int i;
        int segments = 5 + (int)radius;
        Vec2[] vertices = new Vec2[segments];
        for (i = 0; i < segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            double x = center.x + Math.cos(angle) * radius;
            double y = center.y + Math.sin(angle) * radius;
            vertices[i] = new Vec2(x, y);
        }
        for (i = 0; i < segments; ++i) {
            Vec2 v1 = vertices[i];
            Vec2 v2 = vertices[(i + 1) % segments];
            ParticleRenderer.drawTriangle(center, v1, v2, color);
        }
    }

    private static void renderQuad(Vec2 center, double size, double rotation, int color) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        int r = color >> 24 & 0xFF;
        int g = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int a = color & 0xFF;
        double half = size / 2.0;
        Vec2[] vertices = new Vec2[]{new Vec2(-half, -half), new Vec2(-half, half), new Vec2(half, half), new Vec2(half, -half)};
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = ParticleRenderer.rotateVec(vertices[i], rotation);
            vertices[i] = new Vec2(vertices[i].x + center.x, vertices[i].y + center.y);
        }
        for (Vec2 p : vertices) {
            buffer.method_22912(p.x, p.y, 0.0).method_1336(r, g, b, a).method_1344();
        }
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    private static void renderTriangle(Vec2 center, double size, double rotation, int color) {
        double height = Math.sqrt(3.0) / 2.0 * size;
        Vec2[] vertices = new Vec2[]{new Vec2(0.0, -2.0 * height / 3.0), new Vec2(-size / 2.0, height / 3.0), new Vec2(size / 2.0, height / 3.0)};
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = ParticleRenderer.rotateVec(vertices[i], rotation);
            vertices[i] = new Vec2(vertices[i].x + center.x, vertices[i].y + center.y);
        }
        ParticleRenderer.drawTriangle(vertices[0], vertices[1], vertices[2], color);
    }

    private static Vec2 rotateVec(Vec2 v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        return new Vec2(v.x * cos - v.y * sin, v.x * sin + v.y * cos);
    }

    private static void drawTriangle(Vec2 v1, Vec2 v2, Vec2 v3, int color) {
        double cross = (v2.x - v1.x) * (v3.y - v1.y) - (v2.y - v1.y) * (v3.x - v1.x);
        boolean ccw = cross > 0.0;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        int r = color >> 24 & 0xFF;
        int g = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int a = color & 0xFF;
        if (!ccw) {
            for (Vec2 vert : List.of(v1, v2, v3)) {
                buffer.method_22912(vert.x, vert.y, 0.0).method_1336(r, g, b, a).method_1344();
            }
        } else {
            for (Vec2 vert : List.of(v1, v3, v2)) {
                buffer.method_22912(vert.x, vert.y, 0.0).method_1336(r, g, b, a).method_1344();
            }
        }
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    public static void renderTexturedQuad(class_2960 texture, Vec2 center, double size, double rotation, int color) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34543);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        int r = color >> 24 & 0xFF;
        int g = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int a = color & 0xFF;
        double half = size / 2.0;
        Vec2[] corners = new Vec2[]{new Vec2(-half, -half), new Vec2(-half, half), new Vec2(half, half), new Vec2(half, -half)};
        float[] uvs = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
        for (int i = 0; i < 4; ++i) {
            Vec2 rotated = ParticleRenderer.rotateVec(corners[i], rotation);
            Vec2 finalPos = new Vec2(center.x + rotated.x, center.y + rotated.y);
            buffer.method_22912(finalPos.x, finalPos.y, 0.0).method_22913(uvs[i * 2], uvs[i * 2 + 1]).method_1336(r, g, b, a).method_1344();
        }
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    public static void renderAnimatedQuad(class_2960 texture, Vec2 center, double size, double rotation, int color, int frameIndex, int totalFrames) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34543);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        int r = color >> 24 & 0xFF;
        int g = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int a = color & 0xFF;
        double half = size / 2.0;
        float vFrameHeight = 1.0f / (float)totalFrames;
        float vMin = vFrameHeight * (float)frameIndex;
        float vMax = vMin + vFrameHeight;
        Vec2[] corners = new Vec2[]{new Vec2(-half, -half), new Vec2(-half, half), new Vec2(half, half), new Vec2(half, -half)};
        float[] uvs = new float[]{0.0f, vMin, 0.0f, vMax, 1.0f, vMax, 1.0f, vMin};
        for (int i = 0; i < 4; ++i) {
            Vec2 rotated = ParticleRenderer.rotateVec(corners[i], rotation);
            Vec2 finalPos = new Vec2(center.x + rotated.x, center.y + rotated.y);
            buffer.method_22912(finalPos.x, finalPos.y, 0.0).method_22913(uvs[i * 2], uvs[i * 2 + 1]).method_1336(r, g, b, a).method_1344();
        }
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }
}

