/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.composer_reloaded.api.toast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.lilbrocodes.composer_reloaded.api.toast.AbstractToast;

public class ToastManager {
    private final HashMap<Corner, List<AbstractToast>> toastMap = new HashMap();
    private static ToastManager INSTANCE;

    private ToastManager() {
        this.toastMap.put(Corner.TOP_LEFT, new ArrayList());
        this.toastMap.put(Corner.TOP_RIGHT, new ArrayList());
        this.toastMap.put(Corner.BOTTOM_RIGHT, new ArrayList());
        this.toastMap.put(Corner.BOTTOM_LEFT, new ArrayList());
    }

    public static ToastManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ToastManager();
        }
        return INSTANCE;
    }

    public void addToast(AbstractToast toast, Corner corner) {
        this.toastMap.get((Object)corner).add(toast);
        toast.init(class_310.method_1551().field_1772);
    }

    public void render(class_332 context) {
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        for (Corner corner : Corner.values()) {
            int centerX;
            List<AbstractToast> toasts = this.toastMap.get((Object)corner);
            if (toasts.isEmpty()) continue;
            AbstractToast toast = toasts.get(0);
            int centerY = switch (corner) {
                default -> throw new IncompatibleClassChangeError();
                case Corner.TOP_LEFT -> {
                    centerX = toast.margin() + toast.size().x / 2;
                    yield toast.margin() + toast.size().y / 2;
                }
                case Corner.TOP_RIGHT -> {
                    centerX = screenWidth - toast.margin() - toast.size().x / 2;
                    yield toast.margin() + toast.size().y / 2;
                }
                case Corner.BOTTOM_LEFT -> {
                    centerX = toast.margin() + toast.size().x / 2;
                    yield screenHeight - toast.margin() - toast.size().y / 2;
                }
                case Corner.BOTTOM_RIGHT -> {
                    centerX = screenWidth - toast.margin() - toast.size().x / 2;
                    yield screenHeight - toast.margin() - toast.size().y / 2;
                }
            };
            toast.draw(context, centerX, centerY);
            if (!toast.shouldRemove()) continue;
            toasts.remove(0);
        }
    }

    public void clear() {
        this.toastMap.clear();
    }

    public static enum Corner {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

