/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.composer_reloaded.api.toast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.lilbrocodes.composer_reloaded.api.toast.AbstractToast;

public class ToastManager {
    private final HashMap<Corner, List<AbstractToast>> toastMap = new HashMap();
    private static ToastManager INSTANCE;

    private ToastManager() {
        this.toastMap.put(Corner.TOP_LEFT, new ArrayList());
        this.toastMap.put(Corner.TOP_RIGHT, new ArrayList());
        this.toastMap.put(Corner.BOTTOM_RIGHT, new ArrayList());
        this.toastMap.put(Corner.BOTTOM_LEFT, new ArrayList());
    }

    public static ToastManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ToastManager();
        }
        return INSTANCE;
    }

    public void addToast(AbstractToast toast, Corner corner) {
        this.toastMap.get((Object)corner).add(toast);
        toast.init(class_310.method_1551().field_1772);
    }

    public boolean addToastToEmptySlot(AbstractToast toast) {
        boolean alreadyExists = this.toastMap.values().stream().flatMap(Collection::stream).anyMatch(existing -> existing.getClass().equals(toast.getClass()));
        if (alreadyExists) {
            return false;
        }
        for (Corner corner : new Corner[]{Corner.TOP_LEFT, Corner.TOP_RIGHT, Corner.BOTTOM_RIGHT, Corner.BOTTOM_LEFT}) {
            List<AbstractToast> list = this.toastMap.get((Object)corner);
            if (!list.isEmpty()) continue;
            this.addToast(toast, corner);
            return true;
        }
        return false;
    }

    public void render(class_332 context) {
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        for (Corner corner : Corner.values()) {
            int centerX;
            List<AbstractToast> toasts = this.toastMap.get((Object)corner);
            if (toasts.isEmpty()) continue;
            AbstractToast toast = toasts.get(0);
            int centerY = switch (corner.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> {
                    centerX = toast.margin() + toast.size().x / 2;
                    yield toast.margin() + toast.size().y / 2;
                }
                case 1 -> {
                    centerX = screenWidth - toast.margin() - toast.size().x / 2;
                    yield toast.margin() + toast.size().y / 2;
                }
                case 2 -> {
                    centerX = toast.margin() + toast.size().x / 2;
                    yield screenHeight - toast.margin() - toast.size().y / 2;
                }
                case 3 -> {
                    centerX = screenWidth - toast.margin() - toast.size().x / 2;
                    yield screenHeight - toast.margin() - toast.size().y / 2;
                }
            };
            toast.draw(context, centerX, centerY);
            if (!toast.shouldRemove()) continue;
            toasts.remove(0);
        }
    }

    public void clear() {
        this.toastMap.clear();
    }

    public static enum Corner {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

