/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass;

import com.nine.travelerscompass.TCCommon;
import com.nine.travelerscompass.client.hud.HudRenderer;
import com.nine.travelerscompass.client.render.item.TravelersCompassAngle;
import com.nine.travelerscompass.client.render.item.TravelersCompassPriority;
import com.nine.travelerscompass.client.render.item.TravelersCompassState;
import com.nine.travelerscompass.client.screen.CompassScreen;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.init.CreativeTabRegistry;
import com.nine.travelerscompass.init.ItemRegistry;
import com.nine.travelerscompass.init.MenuRegistry;
import com.nine.travelerscompass.mixin.client.accessor.ConditionalItemModelPropertiesAccessor;
import com.nine.travelerscompass.mixin.client.accessor.RangeSelectItemModelPropertiesAccessor;
import com.nine.travelerscompass.network.ForgeNetworkHandler;
import com.nine.travelerscompass.platform.ForgePlatformConfigHelper;
import com.nine.travelerscompass.platform.ForgePlatformRegistryHelper;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.client.event.AddGuiOverlayLayersEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="travelerscompass")
public class TCForge {
    public TCForge(FMLJavaModLoadingContext context) {
        this.loadConfig(context);
        BusGroup busGroup = context.getModBusGroup();
        this.setupProperties();
        FMLCommonSetupEvent.getBus((BusGroup)busGroup).addListener(this::commonSetup);
        FMLCommonSetupEvent.getBus((BusGroup)busGroup).addListener(this::setupNetwork);
        FMLClientSetupEvent.getBus((BusGroup)busGroup).addListener(this::setupClient);
        AddGuiOverlayLayersEvent.getBus((BusGroup)busGroup).addListener(this::setupHud);
        ItemRegistry.init();
        CompassProperties.init();
        CreativeTabRegistry.init();
        MenuRegistry.init();
        ForgePlatformRegistryHelper.ITEMS.register(busGroup);
        ForgePlatformRegistryHelper.DATA_COMPONENTS.register(busGroup);
        ForgePlatformRegistryHelper.TAB.register(busGroup);
        ForgePlatformRegistryHelper.MENUS.register(busGroup);
    }

    private void setupProperties() {
        if (FMLEnvironment.dist.isClient()) {
            ConditionalItemModelPropertiesAccessor.travelerscompass$getConditionalIdMapper().put((Object)ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"priority"), TravelersCompassPriority.MAP_CODEC);
            RangeSelectItemModelPropertiesAccessor.travelerscompass$getRangeSelectIdMapper().put((Object)ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"angle"), TravelersCompassAngle.MAP_CODEC);
            RangeSelectItemModelPropertiesAccessor.travelerscompass$getRangeSelectIdMapper().put((Object)ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"state"), TravelersCompassState.MAP_CODEC);
        }
    }

    public void setupClient(FMLClientSetupEvent setupEvent) {
        MenuScreens.register((MenuType)((MenuType)MenuRegistry.COMPASS_MENU.get()), CompassScreen::new);
        ClientPlayerNetworkEvent.LoggingOut.BUS.addListener(event -> SearchManager.tick());
    }

    private void setupHud(AddGuiOverlayLayersEvent event) {
        event.getLayeredDraw().add(ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"compass_hud"), HudRenderer::renderTick);
    }

    private void setupNetwork(FMLCommonSetupEvent event) {
        ForgeNetworkHandler.init();
    }

    public void loadConfig(FMLJavaModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ForgePlatformConfigHelper.COMMON_CONFIG, "travelerscompass-common.toml");
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ForgePlatformConfigHelper.COST_CONFIG, "travelerscompass-cost.toml");
    }

    public void commonSetup(FMLCommonSetupEvent setupEvent) {
        TCCommon.updateCache();
        TickEvent.ServerTickEvent.Pre.BUS.addListener(event -> SearchManager.tick());
        PlayerEvent.PlayerLoggedInEvent.BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                TCCommon.onServerPlayerLogin(player);
            }
        });
    }
}

