/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientCache;
import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.base.BaseIconButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.SearchProgress;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.utils.FoundBlockPos;
import com.nine.travelerscompass.common.utils.SearchState;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class InfoButton
extends BaseIconButton {
    private final UUID uuid = CompassProperties.COMPASS_UUID.get(this.stack());

    public InfoButton(ButtonGenericSettings settings) {
        super(settings);
        this.refreshTooltip();
    }

    @Override
    protected TextureData getMainLayerTexture() {
        return this.buttonTexturesSet().get(false, this.isHovered);
    }

    @Override
    protected Icon getIcon() {
        return this.isHovered ? CompassUI.CommonTextures.INFO_HOVERED_ICON : CompassUI.CommonTextures.INFO_ICON;
    }

    @Override
    public void refreshTooltip() {
        MutableComponent status;
        TooltipBuilder builder = TooltipBuilder.builder();
        MutableComponent title = Component.translatable((String)"tooltip.travelerscompass.settings.info");
        FoundBlockPos pos = CompassProperties.FOUND_BLOCK_POS.get(this.stack());
        SearchState state = CompassProperties.SEARCH_STATE.get(this.stack());
        if (CompassProperties.PAUSE.get(this.stack()).booleanValue()) {
            status = Component.translatable((String)"tooltip.travelerscompass.settings.info.status.paused").withStyle(ChatFormatting.GRAY);
        } else if (state == SearchState.SEARCHING) {
            SearchProgress searchProgress = ClientCache.PROGRESS_DATA_CACHE.get(this.uuid);
            int percent = 0;
            if (searchProgress != null) {
                percent = searchProgress.progress * 100 / searchProgress.total;
            }
            MutableComponent progress = ClientUtils.coloredComponent(Component.literal((String)(percent + "%")), 0xC8C8C8);
            status = pos.isValid() ? Component.translatable((String)"tooltip.travelerscompass.settings.info.status.scanning", (Object[])new Object[]{progress}).withStyle(ChatFormatting.GRAY) : Component.translatable((String)"tooltip.travelerscompass.settings.info.status.searching", (Object[])new Object[]{progress}).withStyle(ChatFormatting.GRAY);
        } else {
            status = Component.translatable((String)"tooltip.travelerscompass.settings.info.status.idle").withStyle(ChatFormatting.GRAY);
        }
        HudData data = ClientCache.HUD_DATA_CACHE.get(CompassProperties.COMPASS_UUID.get(this.stack()));
        if (data != null) {
            ILocationObject locationObject = data.getLocationObject();
            if (pos.isValid() && locationObject != null) {
                MutableComponent target = Component.translatable((String)"tooltip.travelerscompass.settings.info.target", (Object[])new Object[]{Component.translatable((String)locationObject.descriptionId()).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.WHITE);
                builder.line((Component)target);
                BlockPos blockPos = pos.blockPos();
                if (blockPos != null) {
                    MutableComponent position = Component.translatable((String)"tooltip.travelerscompass.settings.info.position", (Object[])new Object[]{Component.literal((String)(blockPos.getX() + ", " + blockPos.getY() + ", " + blockPos.getZ())).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.WHITE);
                    builder.line((Component)position);
                }
            }
        }
        builder.title((Component)title);
        builder.line((Component)Component.translatable((String)"tooltip.travelerscompass.settings.info.status", (Object[])new Object[]{status}));
        this.setTooltip(builder.buildAsTooltip());
    }

    @Override
    public void tick() {
        this.refreshTooltip();
    }
}

