/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientCache;
import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.ConfigButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.utils.SearchState;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class PauseButton
extends ConfigButton<Boolean> {
    private SearchState cachedState;

    public PauseButton(ButtonGenericSettings settings) {
        super(settings, CompassProperties.PAUSE, (value, hovered) -> !value.booleanValue() ? (hovered.booleanValue() ? CompassUI.CommonTextures.PAUSE_HOVERED_ICON : CompassUI.CommonTextures.PAUSE_ICON) : (hovered != false ? CompassUI.CommonTextures.RESUME_HOVERED_ICON : CompassUI.CommonTextures.RESUME_ICON));
        this.updateState();
    }

    @Override
    public boolean onLeftClick(double mouseX, double mouseY) {
        CompassProperties.toggleToServer(this.stack(), this.data, true);
        ClientCache.HUD_DATA_CACHE.computeIfPresent(this.uuid, (id, hudData) -> {
            hudData.setPaused((Boolean)this.cached);
            return hudData;
        });
        ClientCache.PROGRESS_DATA_CACHE.remove(this.uuid);
        this.updateState();
        return true;
    }

    @Override
    public void updateState() {
        super.updateState();
        this.cachedState = CompassProperties.SEARCH_STATE.get(this.stack());
    }

    @Override
    public void refreshTooltip() {
        TooltipBuilder builder = TooltipBuilder.builder();
        String key = "tooltip.travelerscompass.settings." + ((Boolean)this.cached != false ? "resume" : "pause");
        builder.title(key);
        builder.lineIf((Component)Component.translatable((String)(key + ".warning")).withStyle(ChatFormatting.GRAY), this.cachedState == SearchState.WIDE_SEARCHING && (Boolean)this.cached != false);
        builder.descIf(key, this.shiftPressed);
        this.setTooltip(builder.buildAsTooltip());
    }
}

