/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.ConfigButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.network.chat.Component;

public class SettingsButton<T>
extends ConfigButton<T> {
    private static final String KEY = "tooltip.travelerscompass.settings.";
    public final Function<T, String> descKeyProvider;
    public final Function<T, Component> stateComponentProvider;

    public static SettingsButton<Boolean> create(ButtonGenericSettings settings, DataStorage<Boolean> data, BiFunction<Boolean, Boolean, Icon> iconProvider) {
        return new SettingsButton<Boolean>(settings, data, iconProvider, v -> v != false ? CompassUI.ENABLED : CompassUI.DISABLED);
    }

    public SettingsButton(ButtonGenericSettings settings, DataStorage<T> data, BiFunction<T, Boolean, Icon> iconProvider, Function<T, Component> stateComponentProvider) {
        this(settings, data, iconProvider, v -> KEY + data.id(), stateComponentProvider);
    }

    public SettingsButton(ButtonGenericSettings settings, DataStorage<T> data, BiFunction<T, Boolean, Icon> iconProvider, Function<T, String> descKeyProvider, Function<T, Component> stateComponentProvider) {
        super(settings, data, iconProvider);
        this.descKeyProvider = descKeyProvider;
        this.stateComponentProvider = stateComponentProvider;
        this.updateState();
    }

    @Override
    public boolean onLeftClick(double mouseX, double mouseY) {
        CompassProperties.toggleToServer(this.stack(), this.data);
        return true;
    }

    @Override
    public void refreshTooltip() {
        TooltipBuilder builder = TooltipBuilder.builder();
        String key = KEY + this.data.id();
        builder.title(key);
        builder.descIf(this.descKeyProvider.apply(this.cached), this.shiftPressed);
        builder.state(this.stateComponentProvider.apply(this.cached));
        this.setTooltip(builder.buildAsTooltip());
    }
}

