/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.base.BaseIconButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.utils.SearchState;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class WarningButton
extends BaseIconButton {
    public boolean hidden = false;
    private Warning warning;

    public WarningButton(ButtonGenericSettings settings) {
        super(settings);
        this.refreshTooltip();
    }

    @Override
    protected TextureData getMainLayerTexture() {
        return CompassUI.TabTextures.WARNING_TAB;
    }

    @Override
    protected Icon getIcon() {
        return CompassUI.SettingsTextures.WARNING_SIGN_ICON;
    }

    public void updateState(ItemStack stack) {
        if (this.hidden) {
            return;
        }
        this.warning = CompassProperties.PAUSE.get(stack) != false && CompassProperties.SEARCH_STATE.get(stack) != SearchState.WIDE_SEARCHING ? Warning.PAUSED : (CompassContainer.container(stack).isEmpty() ? Warning.EMPTY : (CompassProperties.BLOCKS.get(stack) == false && CompassProperties.MOBS.get(stack) == false && CompassProperties.SPAWNERS.get(stack) == false && CompassProperties.INVENTORIES.get(stack) == false && CompassProperties.DROP.get(stack) == false && CompassProperties.VILLAGERS.get(stack) == false && CompassProperties.CONTAINERS.get(stack) == false && CompassProperties.FLUIDS.get(stack) == false && CompassProperties.ITEM_ENTITIES.get(stack) == false ? Warning.INACTIVE : Warning.NORMAL));
        this.refreshTooltip();
    }

    @Override
    public void tick() {
        this.refreshTooltip();
    }

    @Override
    public void refreshTooltip() {
        if (this.warning == Warning.NORMAL || this.hidden) {
            this.setTooltip(Tooltip.create((Component)Component.empty()));
            return;
        }
        String key = "tooltip.travelerscompass.warning." + this.warning.name().toLowerCase();
        this.setTooltip(TooltipBuilder.builder().title(key).desc(key).buildAsTooltip());
    }

    public static enum Warning {
        PAUSED,
        EMPTY,
        INACTIVE,
        NORMAL;

    }
}

