/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.hud;

import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.range.IntRangeButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonRangeSettings;
import com.nine.travelerscompass.client.hud.anchor.HudAnchor;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class HudPosButton
extends IntRangeButton {
    private final Component axisComponent;
    protected HudAnchor cachedAnchor;
    private final DataStorage<? extends HudAnchor> dataAnchor;

    public HudPosButton(ButtonRangeSettings settings, int min, int max, Component axisComponent, DataStorage<? extends HudAnchor> dataAnchor, DataStorage<Integer> data) {
        super(settings, min, max, 1, 5, data);
        this.axisComponent = axisComponent;
        this.dataAnchor = dataAnchor;
        this.updateState();
    }

    @Override
    public void updateCache() {
        this.cached = (Number)this.data.get(this.stack());
        if (this.dataAnchor == null) {
            return;
        }
        this.cachedAnchor = this.dataAnchor.get(this.stack());
    }

    @Override
    protected void onValueChanged(Integer oldValue, Integer newValue) {
        this.data.syncToServer(this.stack(), newValue);
    }

    @Override
    public boolean onRightClick(double mouseX, double mouseY) {
        CompassProperties.toggleToServer(this.stack(), this.dataAnchor);
        return true;
    }

    @Override
    public void refreshTooltip() {
        TooltipBuilder builder = TooltipBuilder.builder();
        String key = "tooltip.travelerscompass.settings." + this.data.id();
        builder.title(key);
        builder.line(this.holdToDecreaseComponent());
        builder.line(this.holdToChangeFaster());
        builder.line((Component)Component.translatable((String)"tooltip.travelerscompass.settings.hud_pos.anchor", (Object[])new Object[]{CompassUI.RBM}).withStyle(ChatFormatting.GRAY));
        if (this.shiftPressed) {
            builder.desc((Component)Component.translatable((String)(key + ".desc"), (Object[])new Object[]{this.axisComponent}).withStyle(ChatFormatting.GRAY));
        }
        MutableComponent anchorValue = this.cachedAnchor.asComponent().withColor(0xC8C8C8);
        builder.state((Component)Component.translatable((String)"tooltip.travelerscompass.settings.hud_pos.anchor.value", (Object[])new Object[]{anchorValue}).withStyle(ChatFormatting.GRAY));
        MutableComponent value = Component.literal((String)String.valueOf(this.cached)).withColor(0xC8C8C8);
        builder.state((Component)Component.translatable((String)(key + ".value"), (Object[])new Object[]{value}).withStyle(ChatFormatting.GRAY));
        this.setTooltip(builder.buildAsTooltip());
    }
}

