/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.hud;

import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.range.IntRangeButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonRangeSettings;
import com.nine.travelerscompass.client.hud.HudSize;
import com.nine.travelerscompass.client.hud.HudType;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class HudSizeButton
extends IntRangeButton {
    private final DataStorage<HudSize> sizeData = CompassProperties.HUD_SIZE;
    private HudSize cachedSize;
    private HudType cachedType;
    private final boolean isWidth;

    public HudSizeButton(ButtonRangeSettings settings, boolean isWidth) {
        super(settings, 0, 999, 1, 5, null);
        this.isWidth = isWidth;
        this.updateState();
    }

    @Override
    protected Integer min() {
        return this.isWidth ? this.cachedType.minWidth() : this.cachedType.minHeight();
    }

    @Override
    protected Integer max() {
        return this.isWidth ? this.cachedType.maxWidth() : this.cachedType.maxHeight();
    }

    @Override
    public void updateCache() {
        this.cachedSize = CompassProperties.HUD_SIZE.get(this.stack());
        this.cachedType = CompassProperties.HUD_TYPE.get(this.stack());
        this.cached = this.isWidth ? CompassProperties.HUD_SIZE.get(this.stack()).getWidth(this.cachedType) : CompassProperties.HUD_SIZE.get(this.stack()).getHeight(this.cachedType);
    }

    @Override
    protected void onValueChanged(Integer oldValue, Integer newValue) {
        this.sizeData.syncToServer(this.stack(), this.isWidth ? this.cachedSize.withWidth(this.cachedType, newValue) : this.cachedSize.withHeight(this.cachedType, newValue));
    }

    @Override
    public void refreshTooltip() {
        TooltipBuilder builder = TooltipBuilder.builder();
        String key = "tooltip.travelerscompass.settings." + (this.isWidth ? "hud_width" : "hud_height");
        builder.title(key);
        builder.line(this.holdToDecreaseComponent());
        builder.line(this.holdToChangeFaster());
        builder.line((Component)Component.translatable((String)"tooltip.travelerscompass.settings.hud_pos.anchor", (Object[])new Object[]{CompassUI.RBM}).withStyle(ChatFormatting.GRAY));
        builder.descIf(key, this.shiftPressed);
        MutableComponent value = Component.literal((String)String.valueOf(this.cached)).withColor(0xC8C8C8);
        builder.state((Component)Component.translatable((String)(key + ".value"), (Object[])new Object[]{value}).withStyle(ChatFormatting.GRAY));
        this.setTooltip(builder.buildAsTooltip());
    }
}

