/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.search;

import com.nine.travelerscompass.client.component.button.search.SearchModeButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonSearchModeSettings;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.IconLayer;
import com.nine.travelerscompass.client.utils.TextureData;
import net.minecraft.client.gui.GuiGraphics;

public class FluidSearchModeButton
extends SearchModeButton {
    private int frameIndex = 0;
    private int tickCount = 0;
    final int framesPerTick = 2;
    final int maxFrames = 31;

    public FluidSearchModeButton(ButtonSearchModeSettings settings) {
        super(settings);
    }

    @Override
    public void tick() {
        ++this.tickCount;
        if (this.tickCount % 2 == 0) {
            this.frameIndex = (this.frameIndex + 1) % 31;
        }
    }

    @Override
    public void renderIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Icon icon = this.isToggled() ? this.iconActive : this.iconInactive;
        int yOff = 8 * this.frameIndex;
        TextureData textureData = icon.layers().getFirst().textureData().toBuilder().uv(0, yOff).build();
        IconLayer layer = IconLayer.withProperties(icon.layers().getFirst(), textureData);
        ClientUtils.renderIconLayer(graphics, layer, this.getX(), this.getY());
    }
}

