/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.search;

import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.Toggleable;
import com.nine.travelerscompass.client.component.button.popup.ToggleablePopupButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonSearchModeSettings;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.IconLayer;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class SearchModePopupButton
extends ToggleablePopupButton
implements Toggleable {
    private boolean relevant = true;
    protected final boolean configEnabled;
    private final DataStorage<Boolean> data;
    public final Icon iconActive;
    public final Icon iconInactive;
    public final Icon iconLock;

    public SearchModePopupButton(ButtonSearchModeSettings settings, IconLayer popupLayer, IconLayer connectorLayer) {
        super(settings, popupLayer, connectorLayer);
        this.configEnabled = settings.configEnabled;
        this.data = settings.data;
        this.iconActive = settings.iconActive;
        this.iconInactive = settings.iconInactive;
        this.iconLock = settings.iconLock;
        this.setToggled(this.data.get(this.stack()));
        this.checkRelevancy();
        this.refreshTooltip();
    }

    @Override
    protected Icon getIcon() {
        if (this.configEnabled) {
            if (this.isRelevant() && this.isToggled()) {
                return this.iconActive;
            }
            return this.iconInactive;
        }
        return this.iconLock;
    }

    @Override
    public boolean onLeftClick(double mouseX, double mouseY) {
        CompassProperties.toggleToServer(this.stack(), this.data, true);
        this.setToggled(this.data.get(this.stack()));
        this.checkRelevancy();
        this.refreshTooltip();
        return true;
    }

    @Override
    public void afterPopupClick() {
        this.checkRelevancy();
        this.refreshTooltip();
    }

    @Override
    public void refreshTooltip() {
        String key = "tooltip.travelerscompass.search_mode." + this.data.id();
        MutableComponent desc = Component.translatable((String)(key + ".desc")).withStyle(ChatFormatting.GRAY);
        this.setTooltip(TooltipBuilder.builder().title(key).descIf((Component)desc, this.configEnabled && this.shiftPressed).state(this.configEnabled ? (this.isToggled() ? (this.isRelevant() ? CompassUI.ENABLED : CompassUI.INACTIVE) : CompassUI.DISABLED) : CompassUI.CONFIG_DISABLED).buildAsTooltip());
    }

    @Override
    protected TextureData getMainLayerTexture() {
        return this.buttonTexturesSet().get(this.isToggled(), this.isHovered, this.configEnabled);
    }

    public boolean isRelevant() {
        return this.relevant;
    }

    public void setRelevant(boolean relevant) {
        this.relevant = relevant;
    }

    public void checkRelevancy() {
    }
}

