/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.settings;

import com.nine.travelerscompass.client.component.button.base.BaseButton;
import com.nine.travelerscompass.client.utils.ButtonTexturesSet;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;

public class ButtonGenericSettings {
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public final Supplier<ItemStack> supplier;
    public final Consumer<BaseButton> afterLeftClick;
    public final Consumer<BaseButton> afterRightClick;
    public final Consumer<BaseButton> afterInteraction;
    public final ButtonTexturesSet buttonTexturesSet;
    public final UUID uuid;

    public ButtonGenericSettings(Builder<?> builder) {
        this.x = builder.x;
        this.y = builder.y;
        this.width = builder.width;
        this.height = builder.height;
        this.supplier = builder.supplier;
        this.afterLeftClick = builder.afterLeftClick;
        this.afterRightClick = builder.afterRightClick;
        this.afterInteraction = builder.afterInteraction;
        this.uuid = builder.uuid;
        this.buttonTexturesSet = builder.buttonTexturesSet;
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        protected int x;
        protected int y;
        protected int width;
        protected int height;
        protected Supplier<ItemStack> supplier;
        protected Consumer<BaseButton> afterLeftClick;
        protected Consumer<BaseButton> afterRightClick;
        protected Consumer<BaseButton> afterInteraction;
        protected UUID uuid;
        protected ButtonTexturesSet buttonTexturesSet;

        protected T self() {
            return (T)this;
        }

        public T afterLeftClick(Consumer<BaseButton> afterLeftClick) {
            this.afterLeftClick = afterLeftClick;
            return this.self();
        }

        public T afterRightClick(Consumer<BaseButton> afterRightClick) {
            this.afterRightClick = afterRightClick;
            return this.self();
        }

        public T afterInteraction(Consumer<BaseButton> afterAnyClick) {
            this.afterInteraction = afterAnyClick;
            return this.self();
        }

        public T mainLayerSet(ButtonTexturesSet set) {
            this.buttonTexturesSet = set;
            return this.self();
        }

        public T position(int x, int y) {
            this.x = x;
            this.y = y;
            return this.self();
        }

        public T moved(int x, int y) {
            this.x += x;
            this.y += y;
            return this.self();
        }

        public T size(int width, int height) {
            this.width = width;
            this.height = height;
            return this.self();
        }

        public T stackSup(Supplier<ItemStack> supplier) {
            this.supplier = supplier;
            return this.self();
        }

        public T uuid(UUID uuid) {
            this.uuid = uuid;
            return this.self();
        }

        public void copyParentTo(Builder<?> target) {
            target.x = this.x;
            target.y = this.y;
            target.width = this.width;
            target.height = this.height;
            target.supplier = this.supplier;
            target.afterLeftClick = this.afterLeftClick;
            target.afterRightClick = this.afterRightClick;
            target.afterInteraction = this.afterInteraction;
            target.uuid = this.uuid;
            target.buttonTexturesSet = this.buttonTexturesSet;
        }

        public T copy() {
            Builder<T> copy = new Builder<T>();
            this.copyParentTo(copy);
            return (T)copy;
        }

        public ButtonGenericSettings build() {
            return new ButtonGenericSettings((Builder<?>)this.self());
        }
    }
}

