/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.hud;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.nine.travelerscompass.client.hud.HudType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record HudSize(List<Integer> values) {
    public static final Codec<HudSize> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("values").forGetter(HudSize::values)).apply((Applicative)instance, HudSize::new));
    public static final StreamCodec<ByteBuf, HudSize> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), HudSize::values, HudSize::new);

    public HudSize() {
        this(HudSize.defaultValues());
    }

    private static List<Integer> defaultValues() {
        return Arrays.stream(HudType.values()).flatMap(type -> Stream.of(type.defaultWidth(), type.defaultHeight())).toList();
    }

    public HudSize withWidth(HudType type, int value) {
        ArrayList<Integer> ret = new ArrayList<Integer>(this.values);
        ret.set(type.ordinal() * 2, value);
        return new HudSize(ret);
    }

    public HudSize withHeight(HudType type, int value) {
        ArrayList<Integer> ret = new ArrayList<Integer>(this.values);
        ret.set(type.ordinal() * 2 + 1, value);
        return new HudSize(ret);
    }

    public int getWidth(HudType type) {
        return this.values.get(type.ordinal() * 2);
    }

    public int getHeight(HudType type) {
        return this.values.get(type.ordinal() * 2 + 1);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HudSize)) {
            return false;
        }
        HudSize other = (HudSize)o;
        return this.values.equals(other.values);
    }
}

