/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.hud.type;

import com.nine.travelerscompass.client.hud.Alignment;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.client.hud.type.IHudTypeRenderer;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class ExtendedHudTypeRenderer
implements IHudTypeRenderer {
    public static final int MAX_LINES = 8;

    @Override
    public void render(GuiGraphics graphics, Player player, Font font, HudData hudData, int x, int y, int width, int height) {
        if (hudData.isDirty()) {
            hudData.updateCachedData(font, 0);
            hudData.clearDirty();
        }
        HudSettings settings = hudData.getSettings();
        int xPos = x;
        int yPos = y;
        ILocationObject locationObject = hudData.getLocationObject();
        boolean valid = locationObject != null;
        ArrayList<Component> components = new ArrayList<Component>();
        MutableComponent stateTitle = Component.translatable((String)"hud.travelerscompass.extended.state").withStyle(ChatFormatting.WHITE);
        Component state = hudData.getState();
        components.add((Component)stateTitle);
        components.add(state);
        if (valid) {
            MutableComponent targetTitle = Component.translatable((String)"hud.travelerscompass.extended.target").withStyle(ChatFormatting.WHITE);
            Component target = hudData.getTargetName();
            BlockPos blockPos = locationObject.blockPos();
            components.add((Component)targetTitle);
            components.add(target);
            if (blockPos != null) {
                Component distance = ClientUtils.getDistance(player.blockPosition(), blockPos);
                Component position = ExtendedHudTypeRenderer.formatCoordsExtended(blockPos, font, width);
                MutableComponent distanceTitle = Component.translatable((String)"hud.travelerscompass.extended.distance").withStyle(ChatFormatting.WHITE);
                MutableComponent positionTitle = Component.translatable((String)"hud.travelerscompass.extended.position").withStyle(ChatFormatting.WHITE);
                components.add((Component)positionTitle);
                components.add(position);
                components.add((Component)distanceTitle);
                components.add(distance);
            }
        }
        ExtendedHudTypeRenderer.drawExtendedLines(graphics, font, xPos, yPos, width, height, settings.alignment(), 8, components);
    }

    public static void drawExtendedLines(GuiGraphics graphics, Font font, int xPos, int yPos, int width, int height, Alignment alignment, int maxLines, List<Component> components) {
        if (components.isEmpty()) {
            return;
        }
        maxLines = 4;
        Objects.requireNonNull(font);
        int baseGap = (int)(9.0 * 0.2);
        int extraGaps = (maxLines - 1) / 2;
        Objects.requireNonNull(font);
        int extraGap = (int)(9.0 * 0.4);
        int extraGapsHeight = extraGap * extraGaps;
        Objects.requireNonNull(font);
        int linesHeight = maxLines * (9 * 2 + baseGap) + extraGapsHeight;
        int gap = components.size() > 1 ? (height - linesHeight) / (maxLines - 1) : 0;
        int currentY = yPos;
        int count = 0;
        for (Component component : components) {
            ++count;
            int currentX = xPos;
            switch (alignment) {
                case LEFT: {
                    break;
                }
                case RIGHT: {
                    currentX += width - font.width((FormattedText)component);
                    break;
                }
                case CENTER: {
                    currentX += (width - font.width((FormattedText)component)) / 2;
                }
            }
            graphics.drawString(font, component, currentX, currentY, -5592406);
            Objects.requireNonNull(font);
            currentY += 9 + baseGap;
            if (count % 2 != 0) continue;
            currentY += gap;
        }
    }

    public static Component formatCoordsExtended(BlockPos pos, Font font, int maxWidth) {
        MutableComponent coords = Component.literal((String)(pos.getX() + ", " + pos.getY() + ", " + pos.getZ())).withStyle(ChatFormatting.GRAY);
        if (font.width((FormattedText)coords) <= maxWidth) {
            return coords;
        }
        coords = Component.literal((String)(pos.getX() + ", " + pos.getZ())).withStyle(ChatFormatting.GRAY);
        if (font.width((FormattedText)coords) <= maxWidth) {
            return coords;
        }
        coords = Component.literal((String)(ClientUtils.compressNumber(pos.getX()) + ", " + ClientUtils.compressNumber(pos.getZ()))).withStyle(ChatFormatting.GRAY);
        if (font.width((FormattedText)coords) <= maxWidth) {
            return coords;
        }
        return Component.literal((String)"...").withStyle(ChatFormatting.GRAY);
    }
}

