/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.render.item;

import com.nine.travelerscompass.common.data.CompassProperties;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.NeedleDirectionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class TravelersCompassAngleState
extends NeedleDirectionHelper {
    private final RandomSource random = RandomSource.create();
    private final NeedleDirectionHelper.Wobbler noTargetWobbler = this.newWobbler(0.8f);
    private final NeedleDirectionHelper.Wobbler wobbler = this.newWobbler(0.8f);

    public TravelersCompassAngleState() {
        super(true);
    }

    protected float calculate(ItemStack stack, ClientLevel level, int seed, Entity entity) {
        BlockPos pos = CompassProperties.FOUND_BLOCK_POS.get(stack).blockPos();
        long time = level.getGameTime();
        return !this.isValidCompassTargetPos(pos) ? this.getRandomlySpinningRotation(seed, time) : this.getRotationTowardsCompassTarget(seed, entity, time, pos);
    }

    private float getRandomlySpinningRotation(int seed, long time) {
        if (this.noTargetWobbler.shouldUpdate(time)) {
            this.noTargetWobbler.update(time, this.random.nextFloat());
        }
        float f = this.noTargetWobbler.rotation() + (float)TravelersCompassAngleState.hash(seed) / 2.1474836E9f;
        return Mth.positiveModulo((float)f, (float)1.0f);
    }

    private float getRotationTowardsCompassTarget(int seed, Entity entity, long gameTime, BlockPos targetPos) {
        float ret;
        Player player;
        float toTarget = (float)TravelersCompassAngleState.getAngleFromEntityToPos(entity, targetPos);
        float camYaw = TravelersCompassAngleState.getWrappedVisualRotationY(entity);
        if (entity instanceof Player && (player = (Player)entity).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
            if (this.wobbler.shouldUpdate(gameTime)) {
                this.wobbler.update(gameTime, 0.5f - (camYaw - 0.25f));
            }
            ret = toTarget + this.wobbler.rotation();
        } else {
            ret = 0.5f - (camYaw - 0.25f - toTarget);
        }
        return Mth.positiveModulo((float)ret, (float)1.0f);
    }

    private boolean isValidCompassTargetPos(BlockPos pos) {
        return pos != null;
    }

    private static double getAngleFromEntityToPos(Entity entity, BlockPos pos) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        return Math.atan2(vec3.z() - entity.getZ(), vec3.x() - entity.getX()) / 6.2831854820251465;
    }

    private static float getWrappedVisualRotationY(Entity entity) {
        return Mth.positiveModulo((float)(entity.getVisualRotationYInDegrees() / 360.0f), (float)1.0f);
    }

    private static int hash(int seed) {
        return seed * 1327217883;
    }
}

