/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.utils;

import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.IconLayer;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithContent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class ClientUtils {
    public static MutableComponent coloredComponent(MutableComponent start, int color) {
        return start.withStyle(start.getStyle().withColor(color));
    }

    public static Component getDistance(BlockPos playerPos, BlockPos targetPos) {
        return Component.literal((String)String.valueOf((int)Math.sqrt(playerPos.distSqr((Vec3i)targetPos)))).withStyle(ChatFormatting.GRAY);
    }

    public static Component getLocationObjectTargetName(ILocationObject object) {
        int softColor;
        boolean priority = object.priority();
        int defaultColor = priority ? 13939050 : 0xAAAAAA;
        int n = softColor = priority ? 16176273 : 0xC8C8C8;
        if (object instanceof WithContent) {
            WithContent withContent = (WithContent)((Object)object);
            MutableComponent ret = Component.empty();
            ret.append((Component)ClientUtils.coloredComponent(Component.translatable((String)object.descriptionId()), defaultColor));
            ret.append((Component)ClientUtils.coloredComponent(Component.literal((String)" ["), defaultColor));
            ret.append((Component)ClientUtils.coloredComponent(Component.translatable((String)withContent.contentId()), softColor));
            ret.append((Component)ClientUtils.coloredComponent(Component.literal((String)"]"), defaultColor));
            return ret;
        }
        return ClientUtils.coloredComponent(Component.translatable((String)object.descriptionId()), defaultColor);
    }

    public static Component cutComponent(Font font, Component component, int availableWidth) {
        MutableComponent ret = Component.empty();
        MutableComponent dots = Component.literal((String)"...");
        int dotsWidth = font.width((FormattedText)dots);
        if (availableWidth <= font.width((FormattedText)dots)) {
            return dots;
        }
        int componentWidth = font.width((FormattedText)component);
        if (componentWidth <= availableWidth) {
            return component;
        }
        int widthUsed = 0;
        for (Component content : component.toFlatList()) {
            int contentWidth = font.width((FormattedText)content);
            if (widthUsed + contentWidth + dotsWidth <= availableWidth) {
                ret.append(content);
                widthUsed += contentWidth;
                continue;
            }
            String s = content.getString();
            if (widthUsed + dotsWidth >= availableWidth) {
                ret.append((Component)dots.withStyle(content.getStyle()));
                break;
            }
            MutableComponent formated = Component.literal((String)font.plainSubstrByWidth(s, availableWidth - widthUsed - dotsWidth)).withStyle(content.getStyle()).append((Component)dots.withStyle(content.getStyle()));
            ret.append((Component)formated);
            break;
        }
        return ret;
    }

    public static String compressNumber(int val) {
        int abs = Math.abs(val);
        if (abs >= 1000000) {
            return val / 1000000 + Component.translatable((String)"hud.travelerscompass.number.mega").getString();
        }
        if (abs >= 1000) {
            return val / 1000 + Component.translatable((String)"hud.travelerscompass.number.kilo").getString();
        }
        return String.valueOf(val);
    }

    public static void renderIcon(GuiGraphics graphics, Icon icon, int x, int y) {
        for (IconLayer layer : icon.layers()) {
            ClientUtils.renderIconLayer(graphics, layer, x, y);
        }
    }

    public static void renderIconLayer(GuiGraphics graphics, IconLayer layer, int x, int y) {
        graphics.pose().pushMatrix();
        float scale = layer.scale();
        graphics.pose().translate((float)x + layer.xOffset(), (float)y + layer.yOffset());
        graphics.pose().scale(scale);
        ClientUtils.renderTexture(graphics, layer.textureData(), 0, 0);
        graphics.pose().popMatrix();
    }

    public static void renderTexture(GuiGraphics graphics, TextureData data, int x, int y) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, data.location(), x, y, (float)data.u(), (float)data.v(), data.width(), data.height(), data.width(), data.height(), data.sourceWidth(), data.sourceHeight());
    }
}

