/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.container.menu;

import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import com.nine.travelerscompass.init.ItemRegistry;
import com.nine.travelerscompass.init.MenuRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class CompassMenu
extends AbstractContainerMenu {
    public static final int COMPASS_SLOTS = 9;

    public CompassMenu(int id, Inventory playerInventory, CompassContainer container) {
        super((MenuType)MenuRegistry.COMPASS_MENU.get(), id);
        int j;
        int i;
        int slotIndex = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.addSlot(new Slot(container, slotIndex, 73 + j * 18, 11 + i * 18){

                    public boolean mayPlace(ItemStack stack) {
                        return super.mayPlace(stack);
                    }

                    public boolean isHighlightable() {
                        Item item = CompassMenu.this.getCarried().getItem();
                        FilterReason reason = FilterManager.getFilterReason(item);
                        return item instanceof AirItem || reason.isAllowed();
                    }

                    public boolean mayPickup(Player CompassMenuIn) {
                        return false;
                    }
                });
                ++slotIndex;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot(this, (Container)playerInventory, slotIndex, 9 + j * 18, i * 18 + 87){

                    public boolean mayPlace(ItemStack stack) {
                        return !(stack.getItem() instanceof TravelersCompassItem);
                    }
                });
                ++slotIndex;
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot(this, (Container)playerInventory, i, 9 + i * 18, 145){

                public boolean mayPlace(ItemStack stack) {
                    return !(stack.getItem() instanceof TravelersCompassItem);
                }

                public boolean mayPickup(Player player) {
                    return !(this.getItem().getItem() instanceof TravelersCompassItem);
                }
            });
            ++slotIndex;
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (index > 8 && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = ((Slot)this.slots.get(i)).getItem();
                if (slotStack.getItem() == stack.getItem()) {
                    return ItemStack.EMPTY;
                }
                if (!stack.isEmpty()) continue;
                ItemStack itemstack = slotStack.copy();
                if (!this.mayPlaceToSlot(player, itemstack)) break;
                itemstack.setCount(1);
                CompassContainer container = (CompassContainer)((Slot)this.slots.get((int)i)).container;
                container.setItem(i, itemstack, player);
                break;
            }
        }
        return ItemStack.EMPTY;
    }

    public void clicked(int slotIndex, int dragType, ClickType clickType, Player player) {
        if (slotIndex >= 0 && slotIndex < 9 && !(this.getSlot(slotIndex).getItem().getItem() instanceof TravelersCompassItem)) {
            ItemStack stack = player.getMainHandItem();
            if (stack.getItem() instanceof TravelersCompassItem && clickType == ClickType.QUICK_MOVE) {
                List<Integer> cur = CompassProperties.PRIORITY_SLOTS.get(stack);
                boolean contains = cur.contains(slotIndex);
                ArrayList<Integer> next = new ArrayList<Integer>(cur);
                if (contains) {
                    next.remove((Object)slotIndex);
                } else {
                    next.add(slotIndex);
                }
                if (player.level().isClientSide) {
                    player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
                }
                CompassProperties.PRIORITY_SLOTS.set(stack, List.copyOf(next));
                if (!this.getSlot(slotIndex).getItem().is(Items.AIR)) {
                    SearchManager.updateSlotPriority(CompassProperties.get(stack, CompassProperties.COMPASS_UUID), slotIndex, !contains);
                }
            } else {
                ItemStack carried = this.getCarried().copy();
                if (carried.isEmpty() || carried.is((Item)ItemRegistry.TRAVELERS_COMPASS.get())) {
                    ((Slot)this.slots.get(slotIndex)).set(ItemStack.EMPTY);
                } else {
                    carried.setCount(1);
                    if (this.mayPlaceToSlot(player, carried)) {
                        CompassContainer container = (CompassContainer)((Slot)this.slots.get((int)slotIndex)).container;
                        container.setItem(slotIndex, carried, player);
                    }
                }
                ((Slot)this.slots.get(slotIndex)).setChanged();
                return;
            }
        }
        super.clicked(slotIndex, dragType, clickType, player);
    }

    public boolean mayPlaceToSlot(Player player, ItemStack stack) {
        for (int i = 0; i < 9; ++i) {
            if (!((Slot)this.slots.get(i)).getItem().is(stack.getItem())) continue;
            return false;
        }
        return true;
    }

    public boolean stillValid(Player player) {
        return player.getMainHandItem().getItem().equals(ItemRegistry.TRAVELERS_COMPASS.get());
    }

    public void removed(Player player) {
        super.removed(player);
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof TravelersCompassItem && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SearchManager.removeWatcher(CompassProperties.COMPASS_UUID.get(stack), serverPlayer);
        }
    }
}

