/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.data;

import com.mojang.serialization.Codec;
import com.nine.travelerscompass.client.hud.Alignment;
import com.nine.travelerscompass.client.hud.HudRenderMode;
import com.nine.travelerscompass.client.hud.HudSize;
import com.nine.travelerscompass.client.hud.HudType;
import com.nine.travelerscompass.client.hud.anchor.HudAnchorX;
import com.nine.travelerscompass.client.hud.anchor.HudAnchorY;
import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.common.data.codec.MoreCodecs;
import com.nine.travelerscompass.common.utils.FoundBlockPos;
import com.nine.travelerscompass.common.utils.HeightAttitude;
import com.nine.travelerscompass.common.utils.PriorityMode;
import com.nine.travelerscompass.common.utils.SearchState;
import com.nine.travelerscompass.common.utils.TabPage;
import com.nine.travelerscompass.compat.lootr.LootrSearchMode;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class CompassProperties {
    public static final Map<String, DataStorage<?>> REGISTRY = new HashMap();
    public static final Map<Byte, DataStorage<?>> CLIENT_EDITABLE = new HashMap();
    public static final Map<Byte, DataStorage<?>> NETWORK_REGISTRY = new HashMap();
    public static final Set<DataStorage<?>> SEARCH_OPTIONS = new HashSet();
    private static byte networkDataIndex = 0;
    public static final DataStorage<UUID> COMPASS_UUID = CompassProperties.register("compass_uuid", Util.NIL_UUID, UUIDUtil.CODEC, UUIDUtil.STREAM_CODEC, new RegistrationOption[0]);
    public static final DataStorage<List<Integer>> PRIORITY_SLOTS = CompassProperties.register("priority_slots", ArrayList::new, Codec.list((Codec)Codec.INT), new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<ItemContainerContents> CONTAINER = CompassProperties.register("compass_container", ItemContainerContents.fromItems(new ArrayList()), ItemContainerContents.CODEC, ItemContainerContents.STREAM_CODEC, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> FORCE_CHUNKS_LOAD = CompassProperties.register("force_chunks_load", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Integer> SEARCH_COOLDOWN = CompassProperties.register("cooldown", Integer.valueOf(60), Codec.INT, ByteBufCodecs.INT, new RegistrationOption[0]);
    public static final DataStorage<Integer> ENTITIES_SEARCH_RANGE = CompassProperties.register("entities_search_range", Integer.valueOf(100), (T value) -> Mth.clamp((int)value, (int)1, (int)TCConfig.ENTITIES_SEARCH_RANGE.get()), Codec.INT, ByteBufCodecs.INT, new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Integer> BLOCK_SEARCH_CHUNK_RANGE = CompassProperties.register("blocks_chunk_search_range", Integer.valueOf(6), (T value) -> Mth.clamp((int)value, (int)1, (int)TCConfig.BLOCKS_CHUNK_SEARCH_RANGE.get()), Codec.INT, ByteBufCodecs.INT, new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Integer> WIDE_SEARCH_RANGE = CompassProperties.register("wide_search_range", Integer.valueOf(10), (T value) -> Mth.clamp((int)value, (int)1, (int)TCConfig.WIDE_SEARCH_RANGE.get()), Codec.INT, ByteBufCodecs.INT, new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> PAUSE = CompassProperties.register("pause", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> TARGET_VALIDATION = CompassProperties.register("target_validation", Boolean.valueOf(true), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<HeightAttitude> TARGET_HEIGHT = CompassProperties.register("target_height", HeightAttitude.NONE, MoreCodecs.enumCodec(HeightAttitude.class), MoreCodecs.enumStreamCodec(HeightAttitude.class), new RegistrationOption[0]);
    public static final DataStorage<String> TARGET_ID = CompassProperties.register("target_id", "", Codec.STRING, ByteBufCodecs.STRING_UTF8, new RegistrationOption[0]);
    public static final DataStorage<UUID> TARGET_UUID = CompassProperties.register("target_uuid", Util.NIL_UUID, UUIDUtil.CODEC, UUIDUtil.STREAM_CODEC, new RegistrationOption[0]);
    public static final DataStorage<Boolean> PRIORITY_ITEM_FOUND = CompassProperties.register("priority_item_found", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[0]);
    public static final DataStorage<Integer> COMPASS_STATE = CompassProperties.register("state", Integer.valueOf(0), Codec.INT, ByteBufCodecs.INT, new RegistrationOption[0]);
    public static final DataStorage<SearchState> SEARCH_STATE = CompassProperties.register("searching", SearchState.IDLE, MoreCodecs.enumCodec(SearchState.class), MoreCodecs.enumStreamCodec(SearchState.class), new RegistrationOption[0]);
    public static final DataStorage<FoundBlockPos> FOUND_BLOCK_POS = CompassProperties.register("found_block_pos", FoundBlockPos::new, FoundBlockPos.CODEC, FoundBlockPos.STREAM_CODEC, new RegistrationOption[0]);
    public static final DataStorage<TabPage> TAB_PAGE = CompassProperties.register("tab_page", TabPage.SEARCH, MoreCodecs.enumCodec(TabPage.class), MoreCodecs.enumStreamCodec(TabPage.class), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> HEIGHT_MARKER = CompassProperties.register("height_marker", Boolean.valueOf(true), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<PriorityMode> PRIORITY_MODE = CompassProperties.register("priority_mode", PriorityMode.NORMAL, MoreCodecs.enumCodec(PriorityMode.class), MoreCodecs.enumStreamCodec(PriorityMode.class), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> SOUND_PING = CompassProperties.register("sound_ping", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Alignment> HUD_ALIGNMENT = CompassProperties.register("hud_alignment", Alignment.LEFT, MoreCodecs.enumCodec(Alignment.class), MoreCodecs.enumStreamCodec(Alignment.class), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<HudType> HUD_TYPE = CompassProperties.register("hud_type", HudType.COMPACT, MoreCodecs.enumCodec(HudType.class), MoreCodecs.enumStreamCodec(HudType.class), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<HudRenderMode> HUD_RENDER_MODE = CompassProperties.register("hud_render_mode", HudRenderMode.OFF, MoreCodecs.enumCodec(HudRenderMode.class), MoreCodecs.enumStreamCodec(HudRenderMode.class), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<HudSize> HUD_SIZE = CompassProperties.register("hud_size", HudSize::new, HudSize.CODEC, HudSize.STREAM_CODEC, new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> HUD_WITH_CHAT = CompassProperties.register("hud_with_chat", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Float> HUD_SCALE = CompassProperties.register("hud_scale", () -> Float.valueOf(TCConfig.DEFAULT_HUD_SCALE.get().floatValue()), Codec.FLOAT, ByteBufCodecs.FLOAT, new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Integer> HUD_X_POS = CompassProperties.register("hud_x_pos", TCConfig.DEFAULT_HUD_X_POSITION::get, Codec.INT, ByteBufCodecs.INT, new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Integer> HUD_Y_POS = CompassProperties.register("hud_y_pos", TCConfig.DEFAULT_HUD_Y_POSITION::get, Codec.INT, ByteBufCodecs.INT, new RegistrationOption[]{RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<HudAnchorX> HUD_X_ANCHOR = CompassProperties.register("hud_anchor_x", HudAnchorX.LEFT, MoreCodecs.enumCodec(HudAnchorX.class), MoreCodecs.enumStreamCodec(HudAnchorX.class), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<HudAnchorY> HUD_Y_ANCHOR = CompassProperties.register("hud_anchor_y", HudAnchorY.TOP, MoreCodecs.enumCodec(HudAnchorY.class), MoreCodecs.enumStreamCodec(HudAnchorY.class), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> CONTAINERS = CompassProperties.register("containers", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> VILLAGERS = CompassProperties.register("villagers", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> VILLAGERS_BUYS = CompassProperties.register("villagers_buys", Boolean.valueOf(true), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> VILLAGERS_SELLS = CompassProperties.register("villagers_sells", Boolean.valueOf(true), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> ITEM_ENTITIES = CompassProperties.register("item_entities", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> INVENTORIES = CompassProperties.register("inventories", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> INVENTORIES_PLAYERS = CompassProperties.register("inv_players", Boolean.valueOf(true), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> INVENTORIES_MOBS = CompassProperties.register("inv_mobs", Boolean.valueOf(true), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> FLUIDS = CompassProperties.register("fluids", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> SPAWNERS = CompassProperties.register("spawners", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> BLOCKS = CompassProperties.register("blocks", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> MOBS = CompassProperties.register("mobs", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> DROP = CompassProperties.register("drop", Boolean.valueOf(false), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> ENTITY_CONTAINERS = CompassProperties.register("entity_containers", Boolean.valueOf(true), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<Boolean> BLOCK_CONTAINERS = CompassProperties.register("block_containers", Boolean.valueOf(true), Codec.BOOL, ByteBufCodecs.BOOL, new RegistrationOption[]{RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE});
    public static final DataStorage<LootrSearchMode> LOOTR_MODE = CompassProperties.register("lootr_containers", LootrSearchMode.CLOSED, MoreCodecs.enumCodec(LootrSearchMode.class), MoreCodecs.enumStreamCodec(LootrSearchMode.class), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);

    public static <T> void putDefaultToServer(ItemStack stack, DataStorage<T> data) {
        data.syncToServer(stack, data.defaultValue());
    }

    public static void toggleToServer(ItemStack stack, DataStorage<?> data) {
        CompassProperties.toggleToServer(stack, data, false);
    }

    public static void toggleToServer(ItemStack stack, DataStorage<?> data, boolean forward) {
        Object current = data.get(stack);
        if (current instanceof Boolean) {
            Boolean v = (Boolean)current;
            data.syncToServer(stack, v == false);
        } else if (data.defaultValue().getClass().isEnum()) {
            Class<?> enumClass = data.defaultValue().getClass();
            Enum enumValue = (Enum)current;
            Enum[] values = (Enum[])enumClass.getEnumConstants();
            int nextIndex = (enumValue.ordinal() + (forward ? 1 : values.length - 1)) % values.length;
            Enum next = values[nextIndex];
            data.syncToServer(stack, next);
        } else {
            throw new IllegalArgumentException("Unsupported data type for toggling: " + String.valueOf(current.getClass()));
        }
    }

    public static <T> T get(ItemStack stack, DataStorage<T> dataStorage) {
        return dataStorage.get(stack);
    }

    private static <T> DataStorage<T> register(String id, Supplier<T> defaultSupplier, Codec<T> codec, RegistrationOption ... regOpts) {
        return CompassProperties.register(id, defaultSupplier, (T v) -> v, codec, null, regOpts);
    }

    private static <T> DataStorage<T> register(String id, Supplier<T> defaultSupplier, Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec, RegistrationOption ... regOpts) {
        return CompassProperties.register(id, defaultSupplier, (T v) -> v, codec, streamCodec, regOpts);
    }

    private static <T> DataStorage<T> register(String id, T defaultValue, Codec<T> codec, RegistrationOption ... regOpts) {
        return CompassProperties.register(id, defaultValue, codec, null, regOpts);
    }

    private static <T> DataStorage<T> register(String id, T defaultValue, Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec, RegistrationOption ... regOpts) {
        return CompassProperties.register(id, defaultValue, (T v) -> v, codec, streamCodec, regOpts);
    }

    private static <T> DataStorage<T> register(String id, T defaultValue, Function<T, T> validator, Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec, RegistrationOption ... regOpts) {
        return CompassProperties.register(id, () -> defaultValue, validator, codec, streamCodec, regOpts);
    }

    private static <T> DataStorage<T> register(String id, Supplier<T> defaultSupplier, Function<T, T> validator, Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec, RegistrationOption ... regOpts) {
        byte by = networkDataIndex;
        networkDataIndex = (byte)(by + 1);
        byte networkId = by;
        DataStorage<T> ret = Platform.PLATFORM_REGISTRY.registerDataComponent(id, networkId, defaultSupplier, validator, codec, streamCodec, Arrays.stream(regOpts).toList().contains((Object)RegistrationOption.CACHE_ENCODING));
        REGISTRY.put(id, ret);
        NETWORK_REGISTRY.put(networkId, ret);
        for (RegistrationOption option : regOpts) {
            if (option == RegistrationOption.SEARCH_OPTION) {
                SEARCH_OPTIONS.add(ret);
                continue;
            }
            if (option != RegistrationOption.CLIENT_EDITABLE) continue;
            CLIENT_EDITABLE.put(networkId, ret);
        }
        return ret;
    }

    public static <T> DataStorage<T> getById(byte id) {
        return NETWORK_REGISTRY.get(id);
    }

    public static void init() {
    }

    private static enum RegistrationOption {
        CLIENT_EDITABLE,
        CACHE_ENCODING,
        SEARCH_OPTION;

    }
}

