/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.data;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.init.RegistryProvider;
import com.nine.travelerscompass.network.packet.c2s.CompassDataPacket;
import com.nine.travelerscompass.platform.Platform;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public record DataStorage<T>(String id, byte networkId, Supplier<T> defaultSupplier, Function<T, T> validator, RegistryProvider<DataComponentType<T>> componentProvider) {
    public DataComponentType<T> dataComponent() {
        return (DataComponentType)this.componentProvider.get();
    }

    public T get(ItemStack stack) {
        return (T)(stack.has(this.dataComponent()) ? stack.get(this.dataComponent()) : this.defaultValue());
    }

    public T defaultValue() {
        return this.defaultSupplier.get();
    }

    private T validate(T value) {
        return this.validator.apply(value);
    }

    public void set(ItemStack stack, T value) {
        stack.set(this.dataComponent(), this.validate(value));
    }

    public void syncToServer(ItemStack stack, T value) {
        this.set(stack, value);
        UUID compassUUID = CompassProperties.COMPASS_UUID.get(stack);
        Platform.PLATFORM_NETWORK.sendToServer(new CompassDataPacket<T>(compassUUID, this, value));
    }
}

