/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.item;

import com.nine.travelerscompass.client.ClientCache;
import com.nine.travelerscompass.client.utils.ClientTickable;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithUUID;
import com.nine.travelerscompass.common.utils.FoundBlockPos;
import com.nine.travelerscompass.common.utils.HeightAttitude;
import com.nine.travelerscompass.common.utils.PriorityMode;
import com.nine.travelerscompass.common.utils.SearchState;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import com.nine.travelerscompass.network.packet.s2c.HudDataPacket;
import com.nine.travelerscompass.platform.Platform;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class TravelersCompassItem
extends Item
implements ClientTickable {
    public static final int STATE_EMPTY = 0;
    public static final int STATE_SEARCHING = 1;
    public static final int STATE_FOUND = 2;

    public TravelersCompassItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        CompassContainer compassContainer = CompassContainer.container(stack);
        Vec3 lookVector = player.getLookAngle();
        Vec3 eyePosition = player.getEyePosition(1.0f);
        Vec3 traceEnd = eyePosition.add(lookVector.x * 5.0, lookVector.y * 5.0, lookVector.z * 5.0);
        BlockHitResult hitResult = level.clip(new ClipContext(eyePosition, traceEnd, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        BlockPos blockPos = hitResult.getBlockPos();
        if (!level.isClientSide) {
            ItemStack clickedStack;
            if (player.isShiftKeyDown() && !compassContainer.hasAny(clickedStack = level.getBlockState(blockPos).getBlock().asItem().getDefaultInstance())) {
                compassContainer.setItem(compassContainer.getFirstEmptySlot(), clickedStack, player);
                if (FilterManager.passesFilters(clickedStack)) {
                    level.playSound(null, player.getOnPos(), SoundEvents.LODESTONE_COMPASS_LOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
            UUID uuid = CompassProperties.COMPASS_UUID.get(stack);
            SearchManager.addWatcher(uuid, player.getUUID());
            Platform.PLATFORM.openMenu(player, stack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity living, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (!player.level().isClientSide && player.isShiftKeyDown() && living instanceof Mob) {
            FilterReason filterReason;
            ItemStack eggStack;
            Mob mob = (Mob)living;
            SpawnEggItem eggItem = SpawnEggItem.byId((EntityType)mob.getType());
            CompassContainer compassContainer = CompassContainer.container(stack);
            if (eggItem != null && !compassContainer.hasAny(eggStack = eggItem.getDefaultInstance()) && (filterReason = FilterManager.getFilterReason(mob.getType())).isAllowed()) {
                compassContainer.setItem(compassContainer.getFirstEmptySlot(), eggStack, player);
                player.level().playSound(null, player.getOnPos(), SoundEvents.LODESTONE_COMPASS_LOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void clientInventoryTick(ItemStack stack, ClientLevel level, Entity entity, EquipmentSlot slot) {
        if (entity instanceof Player) {
            boolean selected;
            Player player = (Player)entity;
            FoundBlockPos pos = CompassProperties.FOUND_BLOCK_POS.get(stack);
            UUID uuid = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
            if (uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L) {
                return;
            }
            boolean bl = selected = slot == EquipmentSlot.MAINHAND;
            if (!ClientCache.HUD_DATA_CACHE.containsKey(uuid)) {
                ClientCache.updateAllHudSettings(stack, selected);
            } else {
                ClientCache.HUD_DATA_CACHE.computeIfPresent(uuid, (id, hudData) -> {
                    hudData.setSelected(selected);
                    return hudData;
                });
                if (player.tickCount % 20 == 0) {
                    ClientCache.HUD_DATA_CACHE.computeIfPresent(uuid, (id, hudData) -> {
                        hudData.setSearchState(CompassProperties.SEARCH_STATE.get(stack));
                        return hudData;
                    });
                }
            }
        }
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, EquipmentSlot slot) {
        if (entity instanceof ServerPlayer) {
            boolean validLocation;
            ServerPlayer player = (ServerPlayer)entity;
            UUID uuid = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
            this.syncCompassUUID((Player)player, stack, uuid);
            boolean searching = SearchManager.inQueue(uuid);
            if (!searching && !CompassContainer.container(stack).isEmpty()) {
                this.tryToScan(stack, player, uuid);
            }
            PriorityMode priorityMode = CompassProperties.PRIORITY_MODE.get(stack);
            ILocationObject locationObject = SearchManager.getClosestLocation(player.blockPosition(), uuid, priorityMode);
            boolean bl = validLocation = locationObject != null;
            if (player.tickCount % 5 == 0) {
                UUID targetUUID;
                String targetID;
                FoundBlockPos foundBlockPos;
                CompassContainer container = CompassContainer.container(stack);
                if (player.tickCount % 20 == 0) {
                    SearchState searchState = CompassProperties.SEARCH_STATE.get(stack);
                    if (!searching && searchState != SearchState.IDLE) {
                        CompassProperties.SEARCH_STATE.set(stack, SearchState.IDLE);
                    }
                    if (container.isEmpty()) {
                        SearchManager.clearFoundBlocks(uuid);
                    }
                    if (CompassProperties.TARGET_VALIDATION.get(stack).booleanValue()) {
                        SearchManager.validatePositions((Level)level, uuid);
                    }
                    SearchManager.validatePriority(stack);
                    if (TCConfig.ENABLE_HUD.get().booleanValue()) {
                        ILocationObject clientLocationObject = locationObject;
                        if (clientLocationObject != null && !TCConfig.SHOW_COORDS.get().booleanValue()) {
                            clientLocationObject = clientLocationObject.withBlockPos(null);
                        }
                        Platform.PLATFORM_NETWORK.sendToClient(player, new HudDataPacket(clientLocationObject, uuid));
                    }
                }
                if (!validLocation) {
                    CompassProperties.PRIORITY_ITEM_FOUND.set(stack, false);
                    foundBlockPos = new FoundBlockPos();
                } else {
                    foundBlockPos = new FoundBlockPos(locationObject.blockPos(), true);
                    CompassProperties.PRIORITY_ITEM_FOUND.set(stack, locationObject.priority());
                }
                this.updateState(stack, validLocation, container.isEmpty());
                String string = targetID = validLocation ? locationObject.descriptionId() : "";
                if (validLocation && locationObject instanceof WithUUID) {
                    WithUUID withUUID = (WithUUID)((Object)locationObject);
                    v2 = withUUID.uuid();
                } else {
                    v2 = targetUUID = Util.NIL_UUID;
                }
                if (validLocation && !CompassProperties.FOUND_BLOCK_POS.get(stack).equals(foundBlockPos) && CompassProperties.SOUND_PING.get(stack).booleanValue()) {
                    boolean shouldPing = false;
                    if (!targetUUID.equals(CompassProperties.TARGET_UUID.get(stack))) {
                        shouldPing = true;
                    }
                    if (!targetID.isEmpty() && !targetID.equals(CompassProperties.TARGET_ID.get(stack))) {
                        shouldPing = true;
                    }
                    if (shouldPing) {
                        this.playPingSound(locationObject, (Player)player);
                    }
                }
                CompassProperties.TARGET_ID.set(stack, targetID);
                CompassProperties.TARGET_UUID.set(stack, targetUUID);
                CompassProperties.FOUND_BLOCK_POS.set(stack, foundBlockPos);
            }
            this.updateTargetAttitude(stack, player.blockPosition(), locationObject);
        }
    }

    private void playPingSound(ILocationObject locationObject, Player player) {
        Level level = player.level();
        if (locationObject.priority()) {
            level.playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.3f, 0.3f);
        }
        level.playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.44f + level.random.nextFloat() / 10.0f);
        level.playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 1.0f);
    }

    private void updateState(ItemStack stack, boolean validLocation, boolean empty) {
        int currentState = CompassProperties.COMPASS_STATE.get(stack);
        int newState = 0;
        if (validLocation) {
            newState = 2;
        } else if (CompassProperties.SEARCH_STATE.get(stack) != SearchState.IDLE) {
            newState = 1;
        } else if (!empty) {
            newState = 1;
        }
        if (currentState != newState) {
            CompassProperties.COMPASS_STATE.set(stack, newState);
        }
    }

    private void updateTargetAttitude(ItemStack stack, BlockPos playerPos, ILocationObject locationData) {
        HeightAttitude heightAttitude;
        HeightAttitude current = CompassProperties.TARGET_HEIGHT.get(stack);
        if (locationData == null) {
            heightAttitude = HeightAttitude.NONE;
        } else {
            int tY;
            BlockPos targetPos = locationData.blockPos();
            int pY = playerPos.getY();
            heightAttitude = pY - (tY = targetPos.getY()) > 0 ? HeightAttitude.DOWN : (pY - tY <= -2 ? HeightAttitude.UP : HeightAttitude.SAME);
        }
        if (current != heightAttitude) {
            CompassProperties.TARGET_HEIGHT.set(stack, heightAttitude);
        }
    }

    private void tryToScan(ItemStack stack, ServerPlayer player, UUID uuid) {
        if (!CompassProperties.get(stack, CompassProperties.PAUSE).booleanValue()) {
            int cooldown = CompassProperties.SEARCH_COOLDOWN.get(stack);
            if (cooldown > 0) {
                CompassProperties.SEARCH_COOLDOWN.set(stack, cooldown - 1);
            }
            if (cooldown <= 0) {
                CompassContainer container = CompassContainer.container(stack);
                if (container.isEmpty()) {
                    CompassProperties.SEARCH_COOLDOWN.set(stack, 20);
                    return;
                }
                CompassProperties.SEARCH_COOLDOWN.set(stack, TCConfig.SEARCH_INTERVAL.get());
                CompassProperties.SEARCH_STATE.set(stack, SearchState.SEARCHING);
                SearchManager.startSearch(stack, player, container, false, result -> {
                    CompassProperties.SEARCH_STATE.set(stack, SearchState.IDLE);
                    PriorityMode priorityMode = CompassProperties.PRIORITY_MODE.get(stack);
                    SearchManager.validatePriority(stack);
                    SearchManager.saveClosest(result.get(), player.blockPosition(), uuid, TCConfig.MAX_CACHED_LOCATIONS.get(), priorityMode);
                    if (CompassProperties.TARGET_VALIDATION.get(stack).booleanValue()) {
                        SearchManager.validatePositions((Level)player.level(), uuid);
                    }
                });
            }
        }
    }

    private void syncCompassUUID(Player player, ItemStack stack, UUID uuid) {
        if (uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L) {
            CompassProperties.COMPASS_UUID.set(stack, UUID.randomUUID());
            player.containerMenu.broadcastChanges();
        }
    }
}

