/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.location;

import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithContent;
import com.nine.travelerscompass.common.search.location.WithUUID;
import com.nine.travelerscompass.common.search.location.codec.LocationCodec;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public record ContainerEntityLocationObject(BlockPos blockPos, int slotIndex, boolean priority, String descriptionId, String contentId, UUID uuid) implements ILocationObject,
WithContent,
WithUUID
{
    public static ResourceLocation TYPE = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"container_entity_location_codec");
    public static final LocationCodec<ContainerEntityLocationObject> CODEC = new LocationCodec<ContainerEntityLocationObject>(){

        @Override
        public void write(FriendlyByteBuf buf, ContainerEntityLocationObject obj) {
            this.writePosSafe(buf, obj.blockPos);
            buf.writeInt(obj.slotIndex);
            buf.writeBoolean(obj.priority);
            buf.writeUtf(obj.descriptionId);
            buf.writeUtf(obj.contentId);
            buf.writeUUID(obj.uuid);
        }

        @Override
        public ContainerEntityLocationObject read(FriendlyByteBuf buf) {
            BlockPos blockPos = this.readPosSafe(buf);
            int slotIndex = buf.readInt();
            boolean priority = buf.readBoolean();
            String descriptionId = buf.readUtf();
            String contentId = buf.readUtf();
            UUID uuid = buf.readUUID();
            return new ContainerEntityLocationObject(blockPos, slotIndex, priority, descriptionId, contentId, uuid);
        }
    };

    @Override
    public ResourceLocation type() {
        return TYPE;
    }

    @Override
    public boolean isValid(ServerLevel level) {
        return level.getEntity(this.uuid) != null;
    }

    @Override
    public ILocationObject copy(BlockPos blockPos, int slotIndex, boolean priority, String descriptionId) {
        return new ContainerEntityLocationObject(blockPos, slotIndex, priority, descriptionId, this.contentId, this.uuid);
    }

    @Override
    public Optional<ILocationObject> update(ServerLevel level) {
        Entity entity = level.getEntity(this.uuid);
        if (entity != null && !entity.blockPosition().equals((Object)this.blockPos)) {
            return Optional.of(new ContainerEntityLocationObject(entity.blockPosition(), this.slotIndex, this.priority, this.descriptionId, this.contentId, this.uuid));
        }
        return Optional.of(this);
    }

    @Override
    public String toString() {
        return "Container Entity [" + this.descriptionId + ": " + this.contentId + "], " + String.valueOf(this.blockPos) + (this.priority ? " [priority]" : "");
    }
}

