/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.location;

import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithContent;
import com.nine.travelerscompass.common.search.location.codec.LocationCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;

public record SpawnerLocationObject(BlockPos blockPos, int slotIndex, boolean priority, String descriptionId, String contentId, ResourceLocation blockId) implements ILocationObject,
WithContent
{
    public static ResourceLocation TYPE = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"spawner_location_codec");
    public static final LocationCodec<SpawnerLocationObject> CODEC = new LocationCodec<SpawnerLocationObject>(){

        @Override
        public void write(FriendlyByteBuf buf, SpawnerLocationObject obj) {
            this.writePosSafe(buf, obj.blockPos);
            buf.writeInt(obj.slotIndex);
            buf.writeBoolean(obj.priority);
            buf.writeUtf(obj.descriptionId);
            buf.writeUtf(obj.contentId);
            buf.writeResourceLocation(obj.blockId);
        }

        @Override
        public SpawnerLocationObject read(FriendlyByteBuf buf) {
            BlockPos blockPos = this.readPosSafe(buf);
            int slotIndex = buf.readInt();
            boolean priority = buf.readBoolean();
            String descriptionId = buf.readUtf();
            String containerId = buf.readUtf();
            ResourceLocation blockId = buf.readResourceLocation();
            return new SpawnerLocationObject(blockPos, slotIndex, priority, descriptionId, containerId, blockId);
        }
    };

    @Override
    public ResourceLocation type() {
        return TYPE;
    }

    @Override
    public boolean isValid(ServerLevel level) {
        boolean loaded = level.isLoaded(this.blockPos);
        if (!loaded) {
            return true;
        }
        Block block = level.getBlockState(this.blockPos).getBlock();
        return BuiltInRegistries.BLOCK.get(this.blockId).equals(block);
    }

    @Override
    public ILocationObject copy(BlockPos blockPos, int slotIndex, boolean priority, String descriptionId) {
        return new SpawnerLocationObject(blockPos, slotIndex, priority, descriptionId, this.contentId, this.blockId);
    }

    @Override
    public Optional<ILocationObject> update(ServerLevel level) {
        return Optional.of(this);
    }

    @Override
    public String toString() {
        return "Spawner Location: [" + this.descriptionId + "--" + this.contentId + String.valueOf(this.blockPos) + (this.priority ? " [priority]" : "");
    }
}

