/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.config.cost;

import com.nine.travelerscompass.TCCommon;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.cost.SearchCost;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class SearchCostHelper {
    static final int MAX_CACHE_SIZE = 500;
    public static final Map<Item, SearchCost> CACHED_ITEM_COSTS = new LinkedHashMap<Item, SearchCost>(500, 0.8f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry<Item, SearchCost> eldest) {
            return this.size() > 500;
        }
    };
    public static final Map<Item, SearchCost> ITEM_COSTS = new HashMap<Item, SearchCost>();
    public static final Map<String, SearchCost> TAG_COSTS = new HashMap<String, SearchCost>();

    public static SearchCost getCost(Item item) {
        SearchCost cost = CACHED_ITEM_COSTS.get(item);
        if (cost != null) {
            return cost;
        }
        SearchCost ret = ITEM_COSTS.get(item);
        if (ret != null) {
            CACHED_ITEM_COSTS.put(item, ret);
            return ret;
        }
        List tags = item.builtInRegistryHolder().tags().toList();
        for (TagKey tag : tags) {
            SearchCost searchCost = TAG_COSTS.get(tag.location().toString());
            if (searchCost == null) continue;
            CACHED_ITEM_COSTS.put(item, searchCost);
            return searchCost;
        }
        CACHED_ITEM_COSTS.put(item, SearchCost.FREE);
        return SearchCost.FREE;
    }

    public static Map<String, SearchCost> fromConfig(List<String> list) {
        HashMap<String, SearchCost> ret = new HashMap<String, SearchCost>();
        for (String raw : list) {
            String[] split;
            String line = raw.trim();
            if (line.isEmpty() || (split = line.split("=", 2)).length != 2) continue;
            String id = split[0].trim();
            String[] costData = split[1].trim().split("/", 2);
            try {
                int cost = Integer.parseInt(costData[0]);
                int req = costData.length > 1 ? Integer.parseInt(costData[1]) : 0;
                ret.put(id, new SearchCost(cost, req));
            }
            catch (Exception e) {
                TCCommon.LOGGER.warn("Couldn't parse: {}", (Object)raw);
            }
        }
        return ret;
    }

    public static void updateCosts() {
        ITEM_COSTS.clear();
        TAG_COSTS.clear();
        CACHED_ITEM_COSTS.clear();
        for (Map.Entry<String, SearchCost> data : SearchCostHelper.fromConfig(TCConfig.ITEM_COSTS.get()).entrySet()) {
            ResourceLocation id = ResourceLocation.parse((String)data.getKey());
            Optional optional = BuiltInRegistries.ITEM.getOptional(id);
            optional.ifPresent(item -> ITEM_COSTS.put((Item)item, (SearchCost)data.getValue()));
        }
        for (Map.Entry<String, SearchCost> data : SearchCostHelper.fromConfig(TCConfig.ITEM_TAGS_COSTS.get()).entrySet()) {
            try {
                TAG_COSTS.put(data.getKey(), data.getValue());
            }
            catch (NumberFormatException e) {
                TCCommon.LOGGER.warn("Couldn't parse cost-tag: {}", data);
            }
        }
        CACHED_ITEM_COSTS.putAll(ITEM_COSTS);
    }

    public static boolean consumeXp(Player player, Item item) {
        SearchCost searchCost;
        if (TCConfig.SEARCH_REQUIRES_XP.get().booleanValue() && !player.isCreative() && !(searchCost = SearchCostHelper.getCost(item)).isFree()) {
            if (searchCost.meetsAllConditions(player.experienceLevel)) {
                player.playNotifySound(SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.MASTER, 0.25f, 1.0f);
                player.giveExperienceLevels(-searchCost.costLevel());
                return true;
            }
            return false;
        }
        return true;
    }
}

