/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network.packet.c2s;

import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.container.menu.CompassMenu;
import com.nine.travelerscompass.compat.NEI;
import com.nine.travelerscompass.network.packet.c2s.C2SPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public record GhostTargetPacket(int slotIndex, ItemStack stack, NEI nei) implements C2SPacket
{
    public static final CustomPacketPayload.Type<GhostTargetPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"ghost_target_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GhostTargetPacket> PACKET_CODEC = StreamCodec.ofMember(GhostTargetPacket::encode, GhostTargetPacket::decode);

    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.slotIndex);
        ItemStack.STREAM_CODEC.encode((Object)buf, (Object)this.stack);
        buf.writeEnum((Enum)this.nei);
    }

    public static GhostTargetPacket decode(RegistryFriendlyByteBuf buf) {
        int slotIndex = buf.readVarInt();
        ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
        NEI nei = (NEI)buf.readEnum(NEI.class);
        return new GhostTargetPacket(slotIndex, stack, nei);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void handle(ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof CompassMenu) {
            Container container;
            CompassMenu menu = (CompassMenu)abstractContainerMenu;
            if (this.nei.allowed() && (container = ((Slot)menu.slots.get((int)this.slotIndex)).container) instanceof CompassContainer) {
                CompassContainer container2 = (CompassContainer)container;
                container2.setItem(this.slotIndex, this.stack, (Player)player);
            }
        }
    }
}

