/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.platform;

import com.nine.travelerscompass.config.ConfigSyncManager;
import com.nine.travelerscompass.config.ConfigType;
import com.nine.travelerscompass.config.ConfigValue;
import com.nine.travelerscompass.config.ForgeTCConfig;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.platform.IPlatformConfigHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgePlatformConfigHelper
extends IPlatformConfigHelper {
    public static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.Builder COST_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec COST_CONFIG;

    @Override
    public ConfigValue<Integer> registerInt(String key, int defaultValue, int min, int max, ConfigValue.Section section, ConfigType type, boolean shouldSync, String comment) {
        String path = section.key + "." + key;
        ForgeConfigSpec.IntValue spec = this.getBuilder(type).comment(comment).defineInRange(path, defaultValue, min, max);
        ForgeConfigValue<Integer> ret = new ForgeConfigValue<Integer>(key, defaultValue, section, type, Integer.class, shouldSync, (ForgeConfigSpec.ConfigValue<Integer>)spec);
        ConfigSyncManager.checkSyncable(ret);
        return ret;
    }

    @Override
    public <T> ConfigValue<T> register(String key, T defaultValue, ConfigValue.Section section, ConfigType type, Class<T> clazz, boolean shouldSync, String comment) {
        ForgeConfigSpec.ConfigValue spec;
        String fullPath = section.key + "." + key;
        ForgeConfigSpec.Builder builder = this.getBuilder(type);
        if (defaultValue instanceof Boolean) {
            spec = builder.comment(comment).define(fullPath, (Object)((Boolean)defaultValue));
        } else if (defaultValue instanceof Integer) {
            spec = builder.comment(comment).defineInRange(fullPath, ((Integer)defaultValue).intValue(), Integer.MIN_VALUE, Integer.MAX_VALUE);
        } else if (defaultValue instanceof Double) {
            spec = builder.comment(comment).defineInRange(fullPath, ((Double)defaultValue).doubleValue(), -1.7976931348623157E308, Double.MAX_VALUE);
        } else if (defaultValue instanceof String) {
            spec = builder.comment(comment).define(fullPath, (Object)((String)defaultValue));
        } else if (defaultValue instanceof Enum) {
            spec = builder.comment(comment).defineEnum(fullPath, (Enum)defaultValue);
        } else if (defaultValue instanceof List) {
            spec = builder.comment(comment).defineList(fullPath, new ArrayList((List)defaultValue), el -> el instanceof String);
        } else {
            throw new UnsupportedOperationException("Unsupported config type: " + defaultValue.getClass().getName());
        }
        ForgeConfigValue<T> ret = new ForgeConfigValue<T>(key, defaultValue, section, type, clazz, shouldSync, spec);
        ConfigSyncManager.checkSyncable(ret);
        return ret;
    }

    private ForgeConfigSpec.Builder getBuilder(ConfigType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ConfigType.COST -> COST_BUILDER;
            case ConfigType.COMMON -> COMMON_BUILDER;
        };
    }

    static {
        TCConfig.init();
        ForgeTCConfig.init();
        COMMON_CONFIG = COMMON_BUILDER.build();
        COST_CONFIG = COST_BUILDER.build();
    }

    public static class ForgeConfigValue<T>
    extends ConfigValue<T> {
        private final ForgeConfigSpec.ConfigValue<T> forgeValue;

        public ForgeConfigValue(String key, T defaultValue, ConfigValue.Section section, ConfigType type, Class<T> clazz, boolean shouldSync, ForgeConfigSpec.ConfigValue<T> forgeValue) {
            super(key, defaultValue, section, type, clazz, shouldSync);
            this.forgeValue = forgeValue;
        }

        @Override
        public T get() {
            if (ConfigSyncManager.SYNCED_VALUES.containsKey(this.path())) {
                return (T)ConfigSyncManager.SYNCED_VALUES.get(this.path());
            }
            return (T)this.forgeValue.get();
        }
    }
}

