/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.PopupButton;
import com.nine.travelerscompass.client.component.button.Toggleable;
import com.nine.travelerscompass.client.component.element.NewPopupElement;
import com.nine.travelerscompass.client.component.element.NewRangePopupElement;
import com.nine.travelerscompass.client.hud.HudRenderer;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.RangeUtils;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.common.utils.Alignment;
import com.nine.travelerscompass.common.utils.HudRenderMode;
import com.nine.travelerscompass.common.utils.HudSize;
import com.nine.travelerscompass.common.utils.HudType;
import com.nine.travelerscompass.config.TCConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_768;
import net.minecraft.class_7919;

public class HudButton
extends PopupButton {
    public static final class_2561 HUD_ENABLED = class_2561.method_43471((String)"tooltip.travelerscompass.settings.hud.enabled").method_27692(class_124.field_1080);
    public static final class_2561 HUD_REQUIRES_HAND = class_2561.method_43471((String)"tooltip.travelerscompass.settings.hud.requires_hand").method_27692(class_124.field_1080);
    private final Supplier<class_1799> supplier;
    private final DataStorage<HudRenderMode> data = CompassProperties.HUD_RENDER_MODE;
    private HudRenderMode cachedRenderMode;
    private final UUID uuid;

    public HudButton(int x, int y, final Supplier<class_1799> supplier) {
        super(x, y, 14, 14, ClientData.CONNECTOR_VERTICAL, ClientData.POPUP_3X3, new class_768(0, 0, 13, 13), new class_768(0, 0, 42, 40));
        this.supplier = supplier;
        class_1799 stack = supplier.get();
        this.uuid = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
        this.cachedRenderMode = CompassProperties.get(stack, CompassProperties.HUD_RENDER_MODE);
        HudType hudType = CompassProperties.HUD_TYPE.get(stack);
        final NewRangePopupElement<Integer> widthElement = new NewRangePopupElement<Integer>(9, 9, Integer.valueOf(hudType.minWidth()), Integer.valueOf(hudType.maxWidth()), Integer.valueOf(1), Integer.valueOf(5), RangeUtils.INTEGER, new IconTexture(ClientData.HUD_WIDTH, 2, 2), CompassProperties.HUD_X_POS, supplier){
            private HudType cachedType;
            public HudSize cachedSize;
            {
                super(width, height, minValue, maxValue, step, stepCtrl, adapter, icon, data, supplier3);
                this.cachedType = CompassProperties.HUD_TYPE.get((class_1799)supplier.get());
                this.cachedSize = CompassProperties.HUD_SIZE.get((class_1799)supplier.get());
                this.updateState();
            }

            @Override
            public void updateState() {
                if (this.cachedType == null) {
                    return;
                }
                class_1799 stack = (class_1799)supplier.get();
                this.cachedType = CompassProperties.HUD_TYPE.get((class_1799)supplier.get());
                this.cachedSize = CompassProperties.HUD_SIZE.get((class_1799)supplier.get());
                this.cached = CompassProperties.HUD_SIZE.get(stack).getWidth(this.cachedType);
                this.refreshTooltip();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    HudSettings settings = hudData.getSettings();
                    hudData.updateSettings(settings.toBuilder().width((Integer)this.cached).build());
                    return hudData;
                });
                this.refreshTooltip();
            }

            @Override
            protected String translationKey() {
                return "hud_width";
            }

            @Override
            public Integer max() {
                return this.cachedType.maxWidth();
            }

            @Override
            public Integer min() {
                return this.cachedType.minWidth();
            }

            @Override
            public void set(Integer value) {
                CompassProperties.HUD_SIZE.sendToServer((class_1799)supplier.get(), this.cachedSize.withWidth(this.cachedType, value));
            }
        };
        final NewRangePopupElement<Integer> heightElement = new NewRangePopupElement<Integer>(9, 9, Integer.valueOf(hudType.minHeight()), Integer.valueOf(hudType.maxHeight()), Integer.valueOf(1), Integer.valueOf(5), RangeUtils.INTEGER, new IconTexture(ClientData.HUD_HEIGHT, 3, 2), CompassProperties.HUD_X_POS, supplier){
            private HudType cachedType;
            public HudSize cachedSize;
            {
                super(width, height, minValue, maxValue, step, stepCtrl, adapter, icon, data, supplier3);
                this.cachedType = CompassProperties.HUD_TYPE.get((class_1799)supplier.get());
                this.cachedSize = CompassProperties.HUD_SIZE.get((class_1799)supplier.get());
                this.updateState();
            }

            @Override
            public void updateState() {
                if (this.cachedType == null) {
                    return;
                }
                class_1799 stack = (class_1799)supplier.get();
                this.cachedType = CompassProperties.HUD_TYPE.get((class_1799)supplier.get());
                this.cachedSize = CompassProperties.HUD_SIZE.get((class_1799)supplier.get());
                this.cached = CompassProperties.HUD_SIZE.get(stack).getHeight(this.cachedType);
                this.refreshTooltip();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    HudSettings settings = hudData.getSettings();
                    hudData.updateSettings(settings.toBuilder().height((Integer)this.cached).build());
                    return hudData;
                });
                this.refreshTooltip();
            }

            @Override
            protected String translationKey() {
                return "hud_height";
            }

            @Override
            public Integer max() {
                return this.cachedType.maxHeight();
            }

            @Override
            public Integer min() {
                return this.cachedType.minHeight();
            }

            @Override
            public void set(Integer value) {
                CompassProperties.HUD_SIZE.sendToServer((class_1799)supplier.get(), this.cachedSize.withHeight(this.cachedType, value));
            }
        };
        NewRangePopupElement<Float> scaleElement = new NewRangePopupElement<Float>(9, 9, Float.valueOf(0.2f), Float.valueOf(3.0f), Float.valueOf(0.01f), Float.valueOf(0.1f), RangeUtils.FLOAT, new IconTexture(ClientData.HUD_SCALE, 2, 2), CompassProperties.HUD_SCALE, supplier){

            @Override
            public void updateState() {
                super.updateState();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    HudSettings settings = hudData.getSettings();
                    hudData.updateSettings(settings.toBuilder().scale(((Float)this.cached).floatValue()).build());
                    return hudData;
                });
            }

            @Override
            public void set(Float value) {
                super.set(value);
            }
        };
        NewRangePopupElement<Integer> xPosElement = new NewRangePopupElement<Integer>(9, 9, Integer.valueOf(0), Integer.valueOf(-1), Integer.valueOf(1), Integer.valueOf(10), RangeUtils.INTEGER, new IconTexture(ClientData.HUD_X_POS, 2, 2), CompassProperties.HUD_X_POS, supplier){

            @Override
            public void updateState() {
                super.updateState();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    HudSettings settings = hudData.getSettings();
                    hudData.updateSettings(settings.toBuilder().xPos((Integer)this.cached).build());
                    return hudData;
                });
            }

            @Override
            public void refreshTooltip() {
                this.setTooltip(HudButton.this.getHudAxisPosTooltip((class_1799)supplier.get(), (Integer)this.cached, "x"));
            }

            @Override
            public void set(Integer value) {
                super.set(value);
            }

            @Override
            public Integer max() {
                return class_310.method_1551().method_22683().method_4486() - 4;
            }
        };
        NewRangePopupElement<Integer> yPosElement = new NewRangePopupElement<Integer>(9, 9, Integer.valueOf(0), Integer.valueOf(-1), Integer.valueOf(1), Integer.valueOf(10), RangeUtils.INTEGER, new IconTexture(ClientData.HUD_Y_POS, 2, 2), CompassProperties.HUD_Y_POS, supplier){

            @Override
            public void updateState() {
                super.updateState();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    HudSettings settings = hudData.getSettings();
                    hudData.updateSettings(settings.toBuilder().yPos((Integer)this.cached).build());
                    return hudData;
                });
            }

            @Override
            public void refreshTooltip() {
                this.setTooltip(HudButton.this.getHudAxisPosTooltip((class_1799)supplier.get(), (Integer)this.cached, "y"));
            }

            @Override
            public void set(Integer value) {
                super.set(value);
            }

            @Override
            public Integer max() {
                return class_310.method_1551().method_22683().method_4502() - 4;
            }
        };
        NewPopupElement hudTypeElement = new NewPopupElement(9, 9){
            private HudType cached;
            {
                super(width, height);
                this.updateState();
            }

            @Override
            public void updateState() {
                this.cached = CompassProperties.HUD_TYPE.get((class_1799)supplier.get());
                this.refreshTooltip();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    hudData.updateSettings(hudData.getSettings().toBuilder().hudType(this.cached).build());
                    return hudData;
                });
            }

            @Override
            public void renderElement(class_332 graphics, int xPos, int yPos) {
                TextureData baseLayer = ClientData.SMALL_TOGGLE_BUTTON.get(false, this.isHovered, true);
                IconTexture iconTexture = switch (this.cached) {
                    default -> throw new MatchException(null, null);
                    case HudType.EXTENDED -> {
                        if (this.isHovered) {
                            yield ClientData.HUD_TYPE_EXTENDED_HOVERED.icon(2, 2);
                        }
                        yield ClientData.HUD_TYPE_EXTENDED.icon(2, 2);
                    }
                    case HudType.COMPACT -> this.isHovered ? ClientData.HUD_TYPE_COMPACT_HOVERED.icon(2, 2) : ClientData.HUD_TYPE_COMPACT.icon(2, 2);
                };
                ClientUtils.renderTexture(graphics, baseLayer, xPos, yPos);
                ClientUtils.renderTexture(graphics, iconTexture, xPos, yPos);
            }

            @Override
            public void onClick(int button) {
                CompassProperties.toggleToServer((class_1799)supplier.get(), CompassProperties.HUD_TYPE, button == 1);
                this.updateState();
                widthElement.updateState();
                heightElement.updateState();
            }

            @Override
            public void refreshTooltip() {
                ArrayList<class_2561> ret = new ArrayList<class_2561>();
                String key = "tooltip.travelerscompass.settings.hud.type";
                class_5250 title = class_2561.method_43471((String)key);
                class_5250 state = class_2561.method_43471((String)(key + "." + this.cached.name().toLowerCase())).method_27692(class_124.field_1080);
                ret.add((class_2561)title);
                if (this.shiftPressed) {
                    ret.add((class_2561)ClientUtils.DESC_ARROW.method_27661().method_10852((class_2561)class_2561.method_43471((String)(key + ".desc")).method_27692(class_124.field_1080)));
                }
                ret.add((class_2561)state);
                this.setTooltip(ret);
            }
        };
        NewPopupElement hucChatElement = new NewPopupElement(9, 9){
            private boolean cached;
            {
                super(width, height);
                this.updateState();
            }

            @Override
            public void updateState() {
                this.cached = CompassProperties.HUD_WITH_CHAT.get((class_1799)supplier.get());
                this.refreshTooltip();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    hudData.updateSettings(hudData.getSettings().toBuilder().hudWithChat(this.cached).build());
                    return hudData;
                });
            }

            @Override
            public void renderElement(class_332 graphics, int xPos, int yPos) {
                TextureData baseLayer = ClientData.SMALL_TOGGLE_BUTTON.get(false, this.isHovered, true);
                IconTexture iconTexture = this.cached ? (this.isHovered ? ClientData.HUD_CHAT_ACTIVE_HOVERED.icon(1, 1) : ClientData.HUD_CHAT_ACTIVE.icon(1, 1)) : (this.isHovered ? ClientData.HUD_CHAT_INACTIVE_HOVERED.icon(1, 1) : ClientData.HUD_CHAT_INACTIVE.icon(1, 1));
                ClientUtils.renderTexture(graphics, baseLayer, xPos, yPos);
                ClientUtils.renderTexture(graphics, iconTexture, xPos, yPos);
            }

            @Override
            public void onClick(int button) {
                CompassProperties.toggleToServer((class_1799)supplier.get(), CompassProperties.HUD_WITH_CHAT, button == 1);
                this.updateState();
            }

            @Override
            public void refreshTooltip() {
                ArrayList<class_2561> ret = new ArrayList<class_2561>();
                String key = "tooltip.travelerscompass.settings.hud_with_chat";
                class_5250 title = class_2561.method_43471((String)key);
                class_2561 state = this.cached ? Toggleable.ENABLED : Toggleable.DISABLED;
                ret.add((class_2561)title);
                if (this.shiftPressed) {
                    ret.add((class_2561)ClientUtils.DESC_ARROW.method_27661().method_10852((class_2561)class_2561.method_43471((String)(key + ".desc")).method_27692(class_124.field_1080)));
                }
                ret.add(state);
                this.setTooltip(ret);
            }
        };
        NewPopupElement hudAlignmentButton = new NewPopupElement(9, 9){
            private Alignment cached;
            {
                super(width, height);
                this.updateState();
            }

            @Override
            public void updateState() {
                this.cached = CompassProperties.HUD_ALIGNMENT.get((class_1799)supplier.get());
                this.refreshTooltip();
                ClientData.HUD_DATA_CACHE.computeIfPresent(HudButton.this.uuid, (id, hudData) -> {
                    hudData.updateSettings(hudData.getSettings().toBuilder().alignment(this.cached).build());
                    return hudData;
                });
            }

            @Override
            public void renderElement(class_332 graphics, int xPos, int yPos) {
                TextureData baseLayer = ClientData.SMALL_TOGGLE_BUTTON.get(false, this.isHovered, true);
                IconTexture iconTexture = switch (this.cached) {
                    default -> throw new MatchException(null, null);
                    case Alignment.CENTER -> {
                        if (this.isHovered) {
                            yield ClientData.HUD_ALIGNMENT_CENTER_HOVERED.icon(3, 1);
                        }
                        yield ClientData.HUD_ALIGNMENT_CENTER.icon(3, 1);
                    }
                    case Alignment.LEFT -> {
                        if (this.isHovered) {
                            yield ClientData.HUD_ALIGNMENT_LEFT_HOVERED.icon(1, 1);
                        }
                        yield ClientData.HUD_ALIGNMENT_LEFT.icon(1, 1);
                    }
                    case Alignment.RIGHT -> this.isHovered ? ClientData.HUD_ALIGNMENT_RIGHT_HOVERED.icon(5, 1) : ClientData.HUD_ALIGNMENT_RIGHT.icon(5, 1);
                };
                ClientUtils.renderTexture(graphics, baseLayer, xPos, yPos);
                ClientUtils.renderTexture(graphics, iconTexture, xPos, yPos);
            }

            @Override
            public void onClick(int button) {
                CompassProperties.toggleToServer((class_1799)supplier.get(), CompassProperties.HUD_ALIGNMENT, button == 1);
                this.updateState();
            }

            @Override
            public void refreshTooltip() {
                ArrayList<class_2561> ret = new ArrayList<class_2561>();
                String key = "tooltip.travelerscompass.settings.hud.alignment";
                class_5250 title = class_2561.method_43471((String)key);
                class_5250 state = class_2561.method_43471((String)(key + "." + this.cached.name().toLowerCase())).method_27692(class_124.field_1080);
                ret.add((class_2561)title);
                if (this.shiftPressed) {
                    ArrayList<class_5250> alignedList = new ArrayList<class_5250>();
                    for (Alignment alignment : Alignment.values()) {
                        class_5250 alignComponent = class_2561.method_43471((String)(key + "." + alignment.name().toLowerCase()));
                        if (alignment == this.cached) {
                            ClientUtils.setColor(alignComponent, 0xC8C8C8);
                        } else {
                            alignComponent = alignComponent.method_27692(class_124.field_1080);
                        }
                        alignedList.add(alignComponent);
                    }
                    class_5250 aligns = class_2561.method_43473();
                    for (int i = 0; i < alignedList.size(); ++i) {
                        aligns.method_10852((class_2561)alignedList.get(i));
                        if (i >= alignedList.size() - 1) continue;
                        aligns.method_10852((class_2561)class_2561.method_43470((String)"/"));
                    }
                    class_5250 desc = ClientUtils.DESC_ARROW.method_27661().method_10852((class_2561)class_2561.method_43469((String)"tooltip.travelerscompass.settings.hud.alignment.desc", (Object[])new Object[]{aligns}).method_27692(class_124.field_1080));
                    ret.add((class_2561)desc);
                }
                ret.add((class_2561)state);
                this.setTooltip(ret);
            }
        };
        NewPopupElement resetElement = new NewPopupElement(9, 9){

            @Override
            public void onClick(int button) {
                HudButton.this.resetSettings((class_1799)supplier.get());
            }

            @Override
            public void renderElement(class_332 graphics, int xPos, int yPos) {
                TextureData baseLayer = ClientData.SMALL_TOGGLE_BUTTON.get(false, this.isHovered, true);
                IconTexture iconTexture = this.isHovered ? ClientData.HUD_RESET_HOVERED.icon(3, 2) : ClientData.HUD_RESET.icon(3, 2);
                ClientUtils.renderTexture(graphics, baseLayer, xPos, yPos);
                ClientUtils.renderTexture(graphics, iconTexture, xPos, yPos);
            }

            @Override
            public void refreshTooltip() {
                ArrayList<class_2561> ret = new ArrayList<class_2561>();
                String key = "tooltip.travelerscompass.settings.hud.reset";
                class_5250 title = class_2561.method_43471((String)key);
                ret.add((class_2561)title);
                if (this.shiftPressed) {
                    ret.add((class_2561)ClientUtils.DESC_ARROW.method_27661().method_10852((class_2561)class_2561.method_43471((String)(key + ".desc")).method_27692(class_124.field_1080)));
                }
                this.setTooltip(ret);
            }
        };
        widthElement.init(-37, 2);
        heightElement.init(-26, 2);
        scaleElement.init(-37, 13);
        xPosElement.init(-37, -9);
        yPosElement.init(-26, -9);
        hudAlignmentButton.init(-15, -9);
        hudTypeElement.init(-15, 2);
        resetElement.init(-15, 13);
        hucChatElement.init(-26, 13);
        this.popupElements.add(widthElement);
        this.popupElements.add(heightElement);
        this.popupElements.add(scaleElement);
        this.popupElements.add(xPosElement);
        this.popupElements.add(yPosElement);
        this.popupElements.add(hudAlignmentButton);
        this.popupElements.add(resetElement);
        this.popupElements.add(hudTypeElement);
        this.popupElements.add(hucChatElement);
        this.updateState();
    }

    private List<class_2561> getHudAxisPosTooltip(class_1799 stack, int pos, String axis) {
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        class_5250 title = class_2561.method_43471((String)("tooltip.travelerscompass.settings.hud.position." + axis)).method_27692(class_124.field_1068);
        class_5250 value = class_2561.method_43470((String)String.valueOf(pos));
        ClientUtils.setColor(value, 0xC8C8C8);
        class_5250 offset = class_2561.method_43469((String)"tooltip.travelerscompass.settings.hud.position.value", (Object[])new Object[]{value}).method_27692(class_124.field_1080);
        class_5250 shift = ClientUtils.coloredComponent(class_2561.method_43471((String)"tooltip.travelerscompass.settings.modification.shift"), this.shiftPressed ? 0xAAAAAA : 0xC8C8C8);
        class_5250 ctrl = ClientUtils.coloredComponent(class_2561.method_43471((String)"tooltip.travelerscompass.settings.modification.ctrl"), this.ctrlPressed ? 0xAAAAAA : 0xC8C8C8);
        components.add((class_2561)title);
        components.add((class_2561)class_2561.method_43469((String)"tooltip.travelerscompass.settings.modification.hold_to_decrease", (Object[])new Object[]{shift}).method_27692(class_124.field_1080));
        components.add((class_2561)class_2561.method_43469((String)"tooltip.travelerscompass.settings.modification.hold_to_change_faster", (Object[])new Object[]{ctrl}).method_27692(class_124.field_1080));
        if (this.shiftPressed) {
            String alignmentString = CompassProperties.get(stack, CompassProperties.HUD_ALIGNMENT).toString().toLowerCase();
            class_5250 alignment = ClientUtils.coloredComponent(class_2561.method_43471((String)("tooltip.travelerscompass.settings.hud.position.alignment." + alignmentString)), 0xC8C8C8);
            class_5250 axisComponent = ClientUtils.coloredComponent(class_2561.method_43470((String)axis.toUpperCase()), 0xC8C8C8);
            class_5250 desc = ClientUtils.coloredComponent(class_2561.method_43470((String)"\u25b6"), 0xC8C8C8).method_10852((class_2561)class_2561.method_43469((String)"tooltip.travelerscompass.settings.hud.position.desc", (Object[])new Object[]{axisComponent, alignment}).method_27692(class_124.field_1080));
            components.add((class_2561)desc);
        }
        components.add((class_2561)offset);
        return components;
    }

    public void resetSettings(class_1799 stack) {
        CompassProperties.putDefaultToServer(stack, CompassProperties.HUD_X_POS);
        CompassProperties.putDefaultToServer(stack, CompassProperties.HUD_Y_POS);
        CompassProperties.putDefaultToServer(stack, CompassProperties.HUD_SCALE);
        CompassProperties.putDefaultToServer(stack, CompassProperties.HUD_ALIGNMENT);
        CompassProperties.putDefaultToServer(stack, CompassProperties.HUD_WITH_CHAT);
        CompassProperties.putDefaultToServer(stack, CompassProperties.HUD_TYPE);
        CompassProperties.putDefaultToServer(stack, CompassProperties.HUD_SIZE);
        for (NewPopupElement el : this.popupElements) {
            el.updateState();
        }
    }

    public void updateState() {
        class_1799 stack = this.supplier.get();
        this.cachedRenderMode = this.data.get(stack);
        this.refreshTooltip();
        ClientData.HUD_DATA_CACHE.computeIfPresent(this.uuid, (id, hudData) -> {
            hudData.updateSettings(hudData.getSettings().toBuilder().renderMode(this.cachedRenderMode).build());
            return hudData;
        });
    }

    @Override
    protected boolean isEnabled() {
        return TCConfig.ENABLE_HUD.get();
    }

    @Override
    protected int getPopupXOffset() {
        return -41;
    }

    @Override
    protected int getPopupYOffset() {
        return -13;
    }

    @Override
    protected int getConnectorXOffset() {
        return -1;
    }

    @Override
    protected int getConnectorYOffset() {
        return 1;
    }

    @Override
    protected boolean isPopupVisible() {
        return super.isPopupVisible() && this.isEnabled() && this.cachedRenderMode != HudRenderMode.OFF;
    }

    @Override
    protected void onMainButtonClick(int button) {
        class_1799 stack = this.supplier.get();
        CompassProperties.toggleToServer(stack, this.data, true);
        this.updateState();
    }

    @Override
    protected void renderMainLayer(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        TextureData baseLayer = ClientData.TOGGLE_BUTTON.get(false, this.field_22762, this.isEnabled());
        ClientUtils.renderTexture(graphics, baseLayer, this.method_46426(), this.method_46427());
    }

    @Override
    protected void renderIcon(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isEnabled()) {
            IconTexture iconTexture = switch (this.cachedRenderMode) {
                default -> throw new MatchException(null, null);
                case HudRenderMode.OFF -> {
                    if (this.method_49606()) {
                        yield new IconTexture(ClientData.HUD_OFF_HOVERED, 2, 2);
                    }
                    yield new IconTexture(ClientData.HUD_OFF, 2, 2);
                }
                case HudRenderMode.ALWAYS -> {
                    if (this.method_49606()) {
                        yield new IconTexture(ClientData.HUD_ALWAYS_HOVERED, 2, 2);
                    }
                    yield new IconTexture(ClientData.HUD_ALWAYS, 2, 2);
                }
                case HudRenderMode.HAND_ONLY -> this.method_49606() ? new IconTexture(ClientData.HUD_HAND_HOVERED, 2, 2) : new IconTexture(ClientData.HUD_HAND, 2, 2);
            };
            ClientUtils.renderTexture(graphics, iconTexture, this.method_46426(), this.method_46427());
            if (this.isPopupVisible()) {
                HudRenderer.forceRender(graphics, partialTicks, this.uuid);
            }
        } else {
            ClientUtils.renderTexture(graphics, new IconTexture(ClientData.LOCK, 3, 2), this.method_46426(), this.method_46427());
        }
    }

    @Override
    public void refreshTooltip() {
        class_2561 state;
        String key = "tooltip.travelerscompass.settings.hud";
        class_5250 title = class_2561.method_43471((String)key);
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add((class_2561)title);
        if (this.isEnabled()) {
            switch (this.cachedRenderMode) {
                default: {
                    throw new MatchException(null, null);
                }
                case OFF: {
                    class_2561 class_25612 = Toggleable.DISABLED;
                    break;
                }
                case HAND_ONLY: {
                    class_2561 class_25612 = HUD_REQUIRES_HAND;
                    break;
                }
                case ALWAYS: {
                    class_2561 class_25612 = state = HUD_ENABLED;
                }
            }
            if (this.shiftPressed) {
                list.add((class_2561)class_2561.method_43473().method_10852(ClientUtils.DESC_ARROW).method_10852((class_2561)class_2561.method_43471((String)(key + ".desc")).method_27692(class_124.field_1080)));
            }
        } else {
            state = Toggleable.CONFIG_DISABLED;
        }
        list.add(state);
        this.method_47400(class_7919.method_47407((class_2561)ClientUtils.buildTooltip(list)));
    }
}

