/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.BaseButton;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.SearchProgress;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.utils.FoundBlockPos;
import com.nine.travelerscompass.common.utils.SearchState;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class InfoButton
extends BaseButton {
    private final Supplier<class_1799> supplier;
    private final UUID uuid;

    public InfoButton(int x, int y, int width, int height, Supplier<class_1799> supplier) {
        super(x, y, width, height);
        this.supplier = supplier;
        this.uuid = CompassProperties.COMPASS_UUID.get(supplier.get());
        this.refreshTooltip();
    }

    @Override
    public void refreshTooltip() {
        class_5250 status;
        class_5250 title = class_2561.method_43471((String)"tooltip.travelerscompass.settings.info");
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        class_1799 stack = this.supplier.get();
        FoundBlockPos pos = CompassProperties.FOUND_BLOCK_POS.get(stack);
        SearchState state = CompassProperties.SEARCH_STATE.get(stack);
        if (CompassProperties.PAUSE.get(stack).booleanValue()) {
            status = class_2561.method_43471((String)"tooltip.travelerscompass.settings.info.status.paused").method_27692(class_124.field_1080);
        } else if (state == SearchState.SEARCHING) {
            SearchProgress searchProgress = ClientData.PROGRESS_DATA_CACHE.get(this.uuid);
            int percent = 0;
            if (searchProgress != null) {
                percent = searchProgress.progress * 100 / searchProgress.total;
            }
            class_5250 progress = ClientUtils.coloredComponent(class_2561.method_43470((String)(percent + "%")), 0xC8C8C8);
            status = pos.isValid() ? class_2561.method_43469((String)"tooltip.travelerscompass.settings.info.status.scanning", (Object[])new Object[]{progress}).method_27692(class_124.field_1080) : class_2561.method_43469((String)"tooltip.travelerscompass.settings.info.status.searching", (Object[])new Object[]{progress}).method_27692(class_124.field_1080);
        } else {
            status = class_2561.method_43471((String)"tooltip.travelerscompass.settings.info.status.idle").method_27692(class_124.field_1080);
        }
        class_5250 statusFull = class_2561.method_43469((String)"tooltip.travelerscompass.settings.info.status", (Object[])new Object[]{status});
        components.add((class_2561)title);
        components.add((class_2561)statusFull);
        HudData data = ClientData.HUD_DATA_CACHE.get(CompassProperties.COMPASS_UUID.get(stack));
        if (data != null) {
            ILocationObject locationObject = data.getLocationObject();
            if (pos.isValid() && locationObject != null) {
                class_5250 target = class_2561.method_43469((String)"tooltip.travelerscompass.settings.info.target", (Object[])new Object[]{class_2561.method_43471((String)locationObject.descriptionId()).method_27692(class_124.field_1080)}).method_27692(class_124.field_1068);
                components.add((class_2561)target);
                if (locationObject.blockPos() != null) {
                    class_2338 blockPos = pos.blockPos();
                    class_5250 position = class_2561.method_43469((String)"tooltip.travelerscompass.settings.info.position", (Object[])new Object[]{class_2561.method_43470((String)(blockPos.method_10263() + ", " + blockPos.method_10264() + ", " + blockPos.method_10260())).method_27692(class_124.field_1080)}).method_27692(class_124.field_1068);
                    components.add((class_2561)position);
                }
            }
        }
        this.method_47400(class_7919.method_47407((class_2561)ClientUtils.buildTooltip(components)));
    }

    @Override
    protected void renderMainLayer(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        ClientUtils.renderTexture(graphics, ClientData.TOGGLE_BUTTON.get(false, this.method_49606()), this.method_46426(), this.method_46427());
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        ClientUtils.renderTexture(graphics, this.method_49606() ? ClientData.INFO_HOVERED : ClientData.INFO, this.method_46426() + 4, this.method_46427() + 3);
    }
}

