/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.BaseButton;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.RangeUtils;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class RangeButton<T extends Number>
extends BaseButton
implements RangeUtils.RangeButtonHandler<T> {
    private final IconTexture PLUS = new IconTexture(ClientData.PLUS, 3, 3);
    private final IconTexture PLUS_INACTIVE = new IconTexture(ClientData.PLUS_INACTIVE, 3, 3);
    private final IconTexture PLUS_CTRL = new IconTexture(ClientData.PLUS_HOVERED, 3, 3);
    private final IconTexture MINUS = new IconTexture(ClientData.MINUS, 3, 3);
    private final IconTexture MINUS_INACTIVE = new IconTexture(ClientData.MINUS_INACTIVE, 3, 3);
    private final IconTexture MINUS_CTRL = new IconTexture(ClientData.MINUS_HOVERED, 3, 3);
    private final IconTexture icon;
    private final Supplier<class_1799> supplier;
    private final DataStorage<T> data;
    private final T min;
    private final T max;
    private final RangeUtils.RangeAdapter<T> adapter;
    private T cached;

    public RangeButton(int x, int y, int width, int height, T minValue, T maxValue, RangeUtils.RangeAdapter<T> adapter, IconTexture textureData, DataStorage<T> data, Supplier<class_1799> supplier) {
        super(x, y, width, height);
        this.data = data;
        this.supplier = supplier;
        this.min = minValue;
        this.max = maxValue;
        this.adapter = adapter;
        this.icon = textureData;
        this.updateState();
    }

    @Override
    public T current() {
        return this.cached;
    }

    @Override
    public void set(T value) {
        this.data.sendToServer(this.supplier.get(), value);
    }

    @Override
    public T min() {
        return this.min;
    }

    @Override
    public T max() {
        return this.max;
    }

    @Override
    public RangeUtils.RangeAdapter<T> adapter() {
        return this.adapter;
    }

    public void method_25348(double mouseX, double mouseY) {
        boolean changed = RangeUtils.changeValue(this, this.shiftPressed, this.ctrlPressed);
        if (changed) {
            this.updateState();
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean changed = RangeUtils.changeValue(this, scrollY < 0.0, this.ctrlPressed);
        if (changed) {
            this.updateState();
        }
        return changed && super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public void updateState() {
        class_1799 stack = this.supplier.get();
        this.cached = (Number)this.data.get(stack);
        this.refreshTooltip();
    }

    public void renderIcon(class_332 graphics, int mouseX, int mouseY, float partialTicks, boolean outOfBounds) {
        IconTexture result;
        int xOff = 2;
        if (this.field_22762) {
            result = this.shiftPressed ? (outOfBounds ? this.MINUS_INACTIVE : (this.ctrlPressed ? this.MINUS_CTRL : this.MINUS)) : (outOfBounds ? this.PLUS_INACTIVE : (this.ctrlPressed ? this.PLUS_CTRL : this.PLUS));
            xOff = 3;
        } else {
            result = this.icon;
        }
        ClientUtils.renderTexture(graphics, result, this.method_46426(), this.method_46427());
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        boolean outOfBounds = RangeUtils.isOutOfBounds(this, this.adapter().add(this.cached, (this.ctrlPressed ? 5 : 1) * (this.shiftPressed ? -1 : 1)));
        TextureData baseLayer = ClientData.TOGGLE_BUTTON.get(false, this.method_49606(), !outOfBounds || !this.field_22762);
        ClientUtils.renderTexture(graphics, baseLayer, this.method_46426(), this.method_46427());
        this.renderIcon(graphics, mouseX, mouseY, partialTicks, outOfBounds);
    }

    @Override
    public void refreshTooltip() {
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        components.add((class_2561)class_2561.method_43471((String)("tooltip.travelerscompass.settings." + this.data.id())).method_27692(class_124.field_1068));
        class_5250 shift = ClientUtils.coloredComponent(class_2561.method_43471((String)"tooltip.travelerscompass.settings.modification.shift"), this.shiftPressed ? 0xAAAAAA : 0xC8C8C8);
        class_5250 ctrl = ClientUtils.coloredComponent(class_2561.method_43471((String)"tooltip.travelerscompass.settings.modification.ctrl"), this.ctrlPressed ? 0xAAAAAA : 0xC8C8C8);
        components.add((class_2561)class_2561.method_43469((String)"tooltip.travelerscompass.settings.modification.hold_to_decrease", (Object[])new Object[]{shift}).method_27692(class_124.field_1080));
        components.add((class_2561)class_2561.method_43469((String)"tooltip.travelerscompass.settings.modification.hold_to_change_faster", (Object[])new Object[]{ctrl}).method_27692(class_124.field_1080));
        if (this.shiftPressed) {
            class_5250 desc = class_2561.method_43473().method_10852(ClientUtils.DESC_ARROW).method_10852((class_2561)class_2561.method_43471((String)("tooltip.travelerscompass.settings." + this.data.id() + ".desc")).method_27692(class_124.field_1080));
            components.add((class_2561)desc);
        }
        class_5250 value = class_2561.method_43470((String)String.valueOf(this.cached));
        ClientUtils.setColor(value, 0xC8C8C8);
        components.add((class_2561)class_2561.method_43469((String)("tooltip.travelerscompass.settings." + this.data.id() + ".value"), (Object[])new Object[]{value}).method_27692(class_124.field_1080));
        this.method_47400(class_7919.method_47407((class_2561)ClientUtils.buildTooltip(components)));
    }
}

