/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.ContainersButton;
import com.nine.travelerscompass.client.component.button.HudButton;
import com.nine.travelerscompass.client.component.button.InfoButton;
import com.nine.travelerscompass.client.component.button.InventoriesButton;
import com.nine.travelerscompass.client.component.button.RangeButton;
import com.nine.travelerscompass.client.component.button.ResetButton;
import com.nine.travelerscompass.client.component.button.SearchModeButton;
import com.nine.travelerscompass.client.component.button.SettingsButton;
import com.nine.travelerscompass.client.component.button.TabButton;
import com.nine.travelerscompass.client.component.button.Toggleable;
import com.nine.travelerscompass.client.component.button.VillagersButton;
import com.nine.travelerscompass.client.component.button.WarningButton;
import com.nine.travelerscompass.client.component.button.WideSearchButton;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.RangeUtils;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.container.menu.CompassMenu;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.utils.PriorityMode;
import com.nine.travelerscompass.common.utils.SearchState;
import com.nine.travelerscompass.common.utils.TabPage;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.cost.SearchCost;
import com.nine.travelerscompass.config.cost.SearchCostHelper;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import com.nine.travelerscompass.network.packet.c2s.PausePacket;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_7919;

public class CompassScreen
extends class_465<CompassMenu> {
    private static final class_2960 TEXTURE_1 = class_2960.method_60655((String)"travelerscompass", (String)"textures/gui/container/compass_screen_1.png");
    private static final class_2960 TEXTURE_2 = class_2960.method_60655((String)"travelerscompass", (String)"textures/gui/container/compass_screen_2.png");
    public static final class_2960 PRIORITY_SLOT = class_2960.method_60655((String)"travelerscompass", (String)"textures/gui/priority_slot.png");
    private class_1657 player;
    private class_1799 stack;
    private TabPage tabPage;
    private UUID uuid;
    private int updateTicks;
    private TabButton tabButton1;
    private TabButton tabButton2;
    private WarningButton warningButton;
    private SearchModeButton blocksSearchButton;
    private SearchModeButton mobsSearchButton;
    private ContainersButton containersSearchButton;
    private SearchModeButton fluidsSearchButton;
    private SearchModeButton spawnersSearchButton;
    private SearchModeButton dropsSearchButton;
    private SearchModeButton itemEntitiesSearchButton;
    private InventoriesButton inventoriesSearchButton;
    private VillagersButton villagersSearchButton;
    private SettingsButton pauseButton;
    private WideSearchButton wideSearchButton;
    private InfoButton infoButton;
    private HudButton hudButton;
    private SettingsButton forceChunksLoadButton;
    private SettingsButton targetValidationButton;
    private SettingsButton soundPingButton;
    private SettingsButton attitudeMarkerButton;
    private SettingsButton priorityButton;
    private ResetButton resetButton;
    private RangeButton<Integer> chunksSearchRangeButton;
    private RangeButton<Integer> entitiesSearchRange;
    private RangeButton<Integer> wideSearchRange;

    public CompassScreen(CompassMenu pMenu, class_1661 pPlayerInventory, class_2561 pTitle) {
        super((class_1703)pMenu, pPlayerInventory, pTitle);
        this.field_2792 = 177;
        this.field_2779 = 169;
        this.tabPage = TabPage.SEARCH;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.field_22787 == null) {
            return;
        }
        this.player = this.field_22787.field_1724;
        if (this.player == null) {
            return;
        }
        class_1799 stack = this.player.method_6047();
        if (!(stack.method_7909() instanceof TravelersCompassItem)) {
            return;
        }
        this.stack = stack;
        this.uuid = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
        this.initButtons();
        this.tabPage = CompassProperties.get(stack, CompassProperties.TAB_PAGE);
        this.addTabButtons();
        this.method_37063((class_364)this.warningButton);
        switch (this.tabPage) {
            case SEARCH: {
                this.addSearchButtons();
                break;
            }
            case SETTINGS: {
                this.addSettingsButton();
            }
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.tabPage == TabPage.SETTINGS) {
            this.hudButton.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    protected void method_37432() {
        this.fluidsSearchButton.tick();
        ++this.updateTicks;
        if (this.updateTicks % 2 == 0) {
            this.infoButton.refreshTooltip();
            this.wideSearchButton.refreshTooltip();
            this.wideSearchRange.refreshTooltip();
            this.pauseButton.refreshTooltip();
        }
        if (this.updateTicks % 10 == 0) {
            this.warningButton.updateState(this.stack);
            this.updateTicks = 0;
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
    }

    private void initButtons() {
        this.blocksSearchButton = new SearchModeButton(this.field_2776 + 7, this.field_2800 + 7, 14, 14, TCConfig.ENABLE_BLOCKS_SEARCH.get(), CompassProperties.BLOCKS, new IconTexture(ClientData.BLOCKS_ACTIVE, 2, 2), new IconTexture(ClientData.BLOCKS_INACTIVE, 2, 2), this.stack);
        this.mobsSearchButton = new SearchModeButton(this.field_2776 + 23, this.field_2800 + 7, 14, 14, TCConfig.ENABLE_MOBS_SEARCH.get(), CompassProperties.MOBS, new IconTexture(ClientData.MOBS_ACTIVE, 2, 2), new IconTexture(ClientData.MOBS_INACTIVE, 2, 2), this.stack);
        this.fluidsSearchButton = new SearchModeButton(this, this.field_2776 + 39, this.field_2800 + 23, 14, 14, TCConfig.ENABLE_FLUIDS_SEARCH.get(), CompassProperties.FLUIDS, new IconTexture(ClientData.FLUIDS_ACTIVE, 2, 2), new IconTexture(ClientData.FLUIDS_INACTIVE, 2, 2), this.stack){
            private int frameIndex = 0;
            private int tickCount = 0;
            final int framesPerTick = 2;
            final int maxFrames = 31;

            @Override
            public void tick() {
                ++this.tickCount;
                if (this.tickCount % 2 == 0) {
                    this.frameIndex = (this.frameIndex + 1) % 31;
                }
            }

            @Override
            public void renderIcon(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
                IconTexture icon = this.isToggled() ? this.iconActive : this.iconInactive;
                int yOff = 8 * this.frameIndex;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                TextureData data = icon.textureData().toBuilder().uv(0, yOff).build();
                ClientUtils.renderTexture(graphics, data, this.method_46426() + icon.xOffset(), this.method_46427() + icon.yOffset());
            }
        };
        this.spawnersSearchButton = new SearchModeButton(this.field_2776 + 23, this.field_2800 + 23, 14, 14, TCConfig.ENABLE_SPAWNERS_SEARCH.get(), CompassProperties.SPAWNERS, new IconTexture(ClientData.SPAWNERS_ACTIVE, 2, 2), new IconTexture(ClientData.SPAWNERS_INACTIVE, 2, 2), this.stack);
        this.itemEntitiesSearchButton = new SearchModeButton(this.field_2776 + 23, this.field_2800 + 39, 14, 14, TCConfig.ENABLE_ITEM_ENTITIES_SEARCH.get(), CompassProperties.ITEM_ENTITIES, new IconTexture(ClientData.ITEM_ENTITIES_ACTIVE, 2, 2), new IconTexture(ClientData.ITEM_ENTITIES_INACTIVE, 2, 2), this.stack);
        this.dropsSearchButton = new SearchModeButton(this.field_2776 + 39, this.field_2800 + 39, 14, 14, TCConfig.ENABLE_DROPS_SEARCH.get(), CompassProperties.DROP, new IconTexture(ClientData.DROPS_ACTIVE, 1, 2), new IconTexture(ClientData.DROPS_INACTIVE, 1, 2), this.stack);
        this.containersSearchButton = new ContainersButton(this.field_2776 + 39, this.field_2800 + 7, this.stack);
        this.villagersSearchButton = new VillagersButton(this.field_2776 + 7, this.field_2800 + 23, this.stack);
        this.inventoriesSearchButton = new InventoriesButton(this.field_2776 + 7, this.field_2800 + 39, this.stack);
        this.wideSearchButton = new WideSearchButton(this.field_2776 + 23, this.field_2800 + 55, () -> this.stack){

            @Override
            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                CompassScreen.this.pauseButton.updateState();
            }
        };
        this.infoButton = new InfoButton(this.field_2776 + 39, this.field_2800 + 55, 14, 14, () -> this.stack);
        this.pauseButton = new SettingsButton(this.field_2776 + 7, this.field_2800 + 55, 14, 14, CompassProperties.PAUSE, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.RESUME, 2, 2), new IconTexture(ClientData.RESUME_HOVERED, 2, 2), (class_2561)class_2561.method_43473());
            }
            return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.PAUSE, 2, 2), new IconTexture(ClientData.PAUSE_HOVERED, 2, 2), (class_2561)class_2561.method_43473());
        }, () -> this.stack){
            private SearchState cachedState;
            {
                this.cachedState = SearchState.IDLE;
            }

            @Override
            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                ClientData.HUD_DATA_CACHE.computeIfPresent(CompassScreen.this.uuid, (id, hudData) -> {
                    hudData.setPaused((Boolean)this.cachedValue);
                    return hudData;
                });
                ClientData.PROGRESS_DATA_CACHE.remove(CompassScreen.this.uuid);
                Platform.PLATFORM_NETWORK.sendToServer(new PausePacket(CompassScreen.this.uuid));
            }

            @Override
            public void updateState() {
                super.updateState();
                class_1799 stack = (class_1799)this.supplier.get();
                this.cachedState = CompassProperties.SEARCH_STATE.get(stack);
            }

            @Override
            public void refreshTooltip() {
                ArrayList<class_2561> list = new ArrayList<class_2561>();
                boolean paused = (Boolean)this.cachedValue;
                String key = "tooltip.travelerscompass.settings." + (paused ? "resume" : "pause");
                class_5250 title = class_2561.method_43471((String)key);
                list.add((class_2561)title);
                if (this.cachedState == SearchState.WIDE_SEARCHING && paused) {
                    list.add((class_2561)class_2561.method_43471((String)(key + ".warning")).method_27692(class_124.field_1080));
                }
                if (this.shiftPressed) {
                    list.add((class_2561)class_2561.method_43473().method_10852(ClientUtils.DESC_ARROW).method_10852((class_2561)class_2561.method_43471((String)(key + ".desc")).method_27692(class_124.field_1080)));
                }
                this.method_47400(class_7919.method_47407((class_2561)ClientUtils.buildTooltip(list)));
            }
        };
        this.attitudeMarkerButton = new SettingsButton(this.field_2776 + 39, this.field_2800 + 39, 14, 14, CompassProperties.HEIGHT_MARKER, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.ATTITUDE_MARKER_ACTIVE, 2, 2), new IconTexture(ClientData.ATTITUDE_MARKER_ACTIVE_HOVERED, 2, 2), Toggleable.ENABLED);
            }
            return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.ATTITUDE_MARKER_INACTIVE, 2, 2), new IconTexture(ClientData.ATTITUDE_MARKER_INACTIVE_HOVERED, 2, 2), Toggleable.DISABLED);
        }, () -> this.stack);
        this.priorityButton = new SettingsButton(this, this.field_2776 + 23, this.field_2800 + 39, 14, 14, CompassProperties.PRIORITY_MODE, value -> {
            PriorityMode priorityMode = (PriorityMode)((Object)((Object)value));
            return switch (priorityMode) {
                default -> throw new MatchException(null, null);
                case PriorityMode.OFF -> new SettingsButton.DisplayDataHolder(ClientData.PRIORITY_OFF_ICON, ClientData.PRIORITY_OFF_HOVERED_ICON, (class_2561)class_2561.method_43473());
                case PriorityMode.NORMAL -> new SettingsButton.DisplayDataHolder(ClientData.PRIORITY_NORMAL_ICON, ClientData.PRIORITY_NORMAL_HOVERED_ICON, (class_2561)class_2561.method_43473());
                case PriorityMode.INVERTED -> new SettingsButton.DisplayDataHolder(ClientData.PRIORITY_INVERT_ICON, ClientData.PRIORITY_INVERT_HOVERED_ICON, (class_2561)class_2561.method_43473());
            };
        }, () -> this.stack){

            @Override
            public void refreshTooltip() {
                ArrayList<class_2561> list = new ArrayList<class_2561>();
                String key = "tooltip.travelerscompass.settings.priority_mode";
                class_5250 title = class_2561.method_43471((String)key);
                class_2561 state = switch ((PriorityMode)((Object)this.cachedValue)) {
                    default -> throw new MatchException(null, null);
                    case PriorityMode.OFF -> Toggleable.DISABLED;
                    case PriorityMode.NORMAL -> Toggleable.ENABLED;
                    case PriorityMode.INVERTED -> Toggleable.INVERTED;
                };
                list.add((class_2561)title);
                if (this.shiftPressed) {
                    String descKey = key + ".desc." + ((PriorityMode)((Object)this.cachedValue)).name().toLowerCase();
                    list.add((class_2561)class_2561.method_43473().method_10852(ClientUtils.DESC_ARROW).method_10852((class_2561)class_2561.method_43471((String)descKey).method_27692(class_124.field_1080)));
                }
                list.add(state);
                this.method_47400(class_7919.method_47407((class_2561)ClientUtils.buildTooltip(list)));
            }
        };
        this.soundPingButton = new SettingsButton(this.field_2776 + 7, this.field_2800 + 39, 14, 14, CompassProperties.SOUND_PING, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.SOUND_PING_ACTIVE, 3, 3), new IconTexture(ClientData.SOUND_PING_ACTIVE_HOVERED, 3, 3), Toggleable.ENABLED);
            }
            return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.SOUND_PING_INACTIVE, 3, 3), new IconTexture(ClientData.SOUND_PING_INACTIVE_HOVERED, 3, 3), Toggleable.DISABLED);
        }, () -> this.stack);
        this.warningButton = new WarningButton(this.field_2776 - 17, this.field_2800 + 76, 21, 22, this.stack);
        this.hudButton = new HudButton(this.field_2776 + 7, this.field_2800 + 55, () -> this.stack){

            @Override
            public void onPopupExit() {
                CompassScreen.this.warningButton.hidden = false;
                CompassScreen.this.warningButton.updateState(CompassScreen.this.stack);
            }

            @Override
            public void onPopupEnter() {
                CompassScreen.this.warningButton.hidden = true;
                CompassScreen.this.warningButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43473()));
            }
        };
        this.forceChunksLoadButton = new SettingsButton(this.field_2776 + 39, this.field_2800 + 23, 14, 14, CompassProperties.FORCE_CHUNKS_LOAD, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(ClientData.FORCE_LOAD_ACTIVE.icon(2, 2), ClientData.FORCE_LOAD_ACTIVE_HOVERED.icon(2, 2), Toggleable.ENABLED);
            }
            return new SettingsButton.DisplayDataHolder(ClientData.FORCE_LOAD_INACTIVE.icon(2, 2), ClientData.FORCE_LOAD_INACTIVE_HOVERED.icon(2, 2), Toggleable.DISABLED);
        }, () -> this.stack);
        this.targetValidationButton = new SettingsButton(this.field_2776 + 23, this.field_2800 + 55, 14, 14, CompassProperties.TARGET_VALIDATION, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(ClientData.TARGET_VALIDATION_ACTIVE.icon(3, 2), ClientData.TARGET_VALIDATION_ACTIVE_HOVERED.icon(3, 2), Toggleable.ENABLED);
            }
            return new SettingsButton.DisplayDataHolder(ClientData.TARGET_VALIDATION_INACTIVE.icon(3, 2), ClientData.TARGET_VALIDATION_INACTIVE_HOVERED.icon(3, 2), Toggleable.DISABLED);
        }, () -> this.stack);
        this.resetButton = new ResetButton(this.field_2776 + 39, this.field_2800 + 55, buttonDefault -> {
            this.resetSettings();
            this.entitiesSearchRange.updateState();
            this.chunksSearchRangeButton.updateState();
            this.wideSearchRange.updateState();
        });
        this.chunksSearchRangeButton = new RangeButton<Integer>(this.field_2776 + 23, this.field_2800 + 23, 14, 14, 1, TCConfig.BLOCKS_CHUNK_SEARCH_RANGE.get(), RangeUtils.INTEGER, new IconTexture(ClientData.CHUNKS_RANGE, 2, 2), CompassProperties.BLOCK_SEARCH_CHUNK_RANGE, () -> this.stack);
        this.entitiesSearchRange = new RangeButton<Integer>(this.field_2776 + 23, this.field_2800 + 7, 14, 14, 1, TCConfig.ENTITIES_SEARCH_RANGE.get(), RangeUtils.INTEGER, new IconTexture(ClientData.ENTITIES_RANGE, 2, 2), CompassProperties.ENTITIES_SEARCH_RANGE, () -> this.stack);
        this.wideSearchRange = new RangeButton<Integer>(this.field_2776 + 39, this.field_2800 + 7, 14, 14, 1, TCConfig.WIDE_SEARCH_RANGE.get(), RangeUtils.INTEGER, new IconTexture(ClientData.WIDE_SEARCH_RANGE, 2, 2), CompassProperties.WIDE_SEARCH_RANGE, () -> this.stack);
    }

    private void addSearchButtons() {
        this.method_37063((class_364)this.blocksSearchButton);
        this.method_37063((class_364)this.mobsSearchButton);
        this.method_37063((class_364)this.containersSearchButton);
        this.method_37063((class_364)this.villagersSearchButton);
        this.method_37063((class_364)this.spawnersSearchButton);
        this.method_37063((class_364)this.fluidsSearchButton);
        this.method_37063((class_364)this.inventoriesSearchButton);
        this.method_37063((class_364)this.itemEntitiesSearchButton);
        this.method_37063((class_364)this.dropsSearchButton);
        this.method_37063((class_364)this.pauseButton);
        this.method_37063((class_364)this.wideSearchButton);
        this.method_37063((class_364)this.infoButton);
    }

    private void removeSearchButtons() {
        this.method_37066((class_364)this.blocksSearchButton);
        this.method_37066((class_364)this.mobsSearchButton);
        this.method_37066((class_364)this.containersSearchButton);
        this.method_37066((class_364)this.villagersSearchButton);
        this.method_37066((class_364)this.spawnersSearchButton);
        this.method_37066((class_364)this.fluidsSearchButton);
        this.method_37066((class_364)this.inventoriesSearchButton);
        this.method_37066((class_364)this.itemEntitiesSearchButton);
        this.method_37066((class_364)this.dropsSearchButton);
        this.method_37066((class_364)this.pauseButton);
        this.method_37066((class_364)this.wideSearchButton);
        this.method_37066((class_364)this.infoButton);
    }

    private void addSettingsButton() {
        this.method_37063((class_364)this.hudButton);
        this.method_37063((class_364)this.forceChunksLoadButton);
        this.method_37063((class_364)this.targetValidationButton);
        this.method_37063((class_364)this.attitudeMarkerButton);
        this.method_37063((class_364)this.soundPingButton);
        this.method_37063((class_364)this.priorityButton);
        this.method_37063((class_364)this.chunksSearchRangeButton);
        this.method_37063((class_364)this.entitiesSearchRange);
        this.method_37063((class_364)this.wideSearchRange);
        this.method_37063((class_364)this.resetButton);
    }

    private void removeSettingsButton() {
        this.method_37066((class_364)this.hudButton);
        this.method_37066((class_364)this.forceChunksLoadButton);
        this.method_37066((class_364)this.targetValidationButton);
        this.method_37066((class_364)this.attitudeMarkerButton);
        this.method_37066((class_364)this.soundPingButton);
        this.method_37066((class_364)this.priorityButton);
        this.method_37066((class_364)this.chunksSearchRangeButton);
        this.method_37066((class_364)this.entitiesSearchRange);
        this.method_37066((class_364)this.wideSearchRange);
        this.method_37066((class_364)this.resetButton);
    }

    private void addTabButtons() {
        boolean searchMode = this.tabPage == TabPage.SEARCH;
        this.tabButton1 = (TabButton)this.method_37063((class_364)new TabButton(this.field_2776 + 130, this.field_2800 + 8, 26, 24, 6, 4, searchMode, ClientData.SEARCH, button -> {
            if (this.tabPage == TabPage.SETTINGS) {
                this.tabButton1.enabled = true;
                this.tabButton2.enabled = false;
                CompassProperties.TAB_PAGE.sendToServer(this.stack, TabPage.SEARCH);
                this.tabPage = TabPage.SEARCH;
                this.addSearchButtons();
                this.removeSettingsButton();
            }
        }, (class_2561)class_2561.method_43471((String)"tooltip.travelerscompass.search")));
        this.tabButton2 = new TabButton(this.field_2776 + 130, this.field_2800 + 42, 26, 24, 6, 4, !searchMode, ClientData.SETTINGS, button -> {
            if (this.tabPage == TabPage.SEARCH) {
                this.tabButton1.enabled = false;
                this.tabButton2.enabled = true;
                CompassProperties.TAB_PAGE.sendToServer(this.stack, TabPage.SETTINGS);
                this.tabPage = TabPage.SETTINGS;
                this.addSettingsButton();
                this.removeSearchButtons();
            }
        }, (class_2561)class_2561.method_43471((String)"tooltip.travelerscompass.settings"));
        this.method_37063((class_364)this.tabButton1);
        this.method_37063((class_364)this.tabButton2);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.method_2380(guiGraphics, mouseX, mouseY);
        if (this.field_22787 != null && this.field_22787.field_1724 != null && this.field_22787.field_1724.method_6047().method_7909() instanceof TravelersCompassItem) {
            this.stack = this.field_22787.field_1724.method_6047();
        }
    }

    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        if (!TCConfig.SEARCH_REQUIRES_XP.get().booleanValue()) {
            return;
        }
        class_1735 slot = this.field_2787;
        if (slot != null && slot.field_7871 instanceof CompassContainer) {
            class_1792 carried = ((CompassMenu)this.method_17577()).method_34255().method_7909();
            SearchCost sc = SearchCostHelper.getCost(carried);
            FilterReason reason = FilterManager.getFilterReason(carried);
            if (reason instanceof FilterReason.Allowed) {
                if (!sc.isFree() && !this.player.method_7337()) {
                    ArrayList<class_5250> extra = new ArrayList<class_5250>();
                    extra.add(sc.reqAsComponent().method_27692(sc.meetsRequirement(this.player.field_7520) ? class_124.field_1080 : class_124.field_1061));
                    extra.add(sc.costAsComponent().method_27692(class_124.field_1080));
                    guiGraphics.method_51434(this.field_22793, extra, mouseX, mouseY);
                }
            } else {
                guiGraphics.method_51438(this.field_22793, ClientUtils.formatReason(reason), mouseX, mouseY);
            }
        }
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && this.stack != null) {
            graphics.method_25302(this.tabPage.equals((Object)TabPage.SEARCH) ? TEXTURE_1 : TEXTURE_2, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
            for (int i : CompassProperties.get(this.stack, CompassProperties.PRIORITY_SLOTS)) {
                int j = i > 2 ? 1 : 0;
                j = i > 5 ? 2 : j;
                int c = i > 2 ? i - 3 : i;
                c = i > 5 ? i - 6 : c;
                graphics.method_25290(PRIORITY_SLOT, this.field_2776 + 72 + c * 18, this.field_2800 + 10 + j * 18, 0.0f, 0.0f, 18, 18, 18, 18);
            }
        }
    }

    private void resetSettings() {
        List<DataStorage<Integer>> toReset = List.of(CompassProperties.TARGET_VALIDATION, CompassProperties.SOUND_PING, CompassProperties.HEIGHT_MARKER, CompassProperties.HUD_RENDER_MODE, CompassProperties.PRIORITY_MODE, CompassProperties.FORCE_CHUNKS_LOAD, CompassProperties.ENTITIES_SEARCH_RANGE, CompassProperties.BLOCK_SEARCH_CHUNK_RANGE, CompassProperties.WIDE_SEARCH_RANGE);
        for (DataStorage<Integer> data : toReset) {
            CompassProperties.putDefaultToServer(this.stack, data);
        }
        this.targetValidationButton.updateState();
        this.soundPingButton.updateState();
        this.attitudeMarkerButton.updateState();
        this.priorityButton.updateState();
        this.forceChunksLoadButton.updateState();
        this.entitiesSearchRange.updateState();
        this.chunksSearchRangeButton.updateState();
        this.wideSearchRange.updateState();
        this.hudButton.resetSettings(this.stack);
        this.hudButton.updateState();
    }

    public int leftPos() {
        return this.field_2776;
    }

    public int topPos() {
        return this.field_2800;
    }
}

