/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.utils;

import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithContent;
import com.nine.travelerscompass.config.filter.FilterReason;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ClientUtils {
    public static final int SOFT_GRAY = 0xC8C8C8;
    public static final int GRAY = 0xAAAAAA;
    public static final int HONEY = 13939050;
    public static final int SOFT_HONEY = 16176273;
    public static final int SOFT_GREEN = 11462271;
    public static final int SOFT_RED = 12077385;
    public static final float MAX_SCALE = 3.0f;
    public static final float MIN_SCALE = 0.3f;
    public static final class_2960 SPACE_HELPER = class_2960.method_60655((String)"travelerscompass", (String)"space_helper");
    public static final class_2561 DESC_ARROW_INDENT = class_2561.method_43470((String)"\uf820").method_27696(class_2583.field_24360.method_27704(SPACE_HELPER));
    public static final class_2561 DESC_ARROW = ClientUtils.coloredComponent(class_2561.method_43470((String)"\u25b6").method_10852(DESC_ARROW_INDENT), 0xC8C8C8);
    public static final class_2561 DISABLED = class_2561.method_43471((String)"tooltip.travelerscompass.disabled").method_27692(class_124.field_1080);
    public static final class_2561 ENABLED = class_2561.method_43471((String)"tooltip.travelerscompass.enabled").method_27692(class_124.field_1080);

    public static class_2561 buildTooltip(class_2561 title, class_2561 ... toAppend) {
        class_5250 ret = class_2561.method_43473().method_10852(title);
        for (class_2561 component : toAppend) {
            ret = ret.method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852(component);
        }
        return ret;
    }

    public static class_2561 buildSearchModeTooltip(String titleKey, List<String> descKeys, boolean state) {
        return ClientUtils.buildToggleTooltip(titleKey, descKeys, ENABLED, DISABLED, state);
    }

    public static class_2561 buildToggleTooltip(String titleKey, List<String> descKeys, class_2561 enabled, class_2561 disabled, boolean state) {
        List<class_2561> components = ClientUtils.buildToggleComponentsList(titleKey, descKeys, state ? enabled : disabled);
        return ClientUtils.buildTooltip(components);
    }

    public static class_2561 buildSearchModeTooltip(String titleKey, List<String> descKeys, class_2561 state) {
        List<class_2561> components = ClientUtils.buildToggleComponentsList(titleKey, descKeys, state);
        return ClientUtils.buildTooltip(components);
    }

    public static List<class_2561> buildToggleComponentsList(String titleKey, List<String> descKeys, boolean state) {
        return ClientUtils.buildToggleComponentsList(titleKey, descKeys, state ? ENABLED : DISABLED);
    }

    public static List<class_2561> buildToggleComponentsList(String titleKey, List<String> descKeys, class_2561 enabled, class_2561 disabled, boolean state) {
        return ClientUtils.buildToggleComponentsList(titleKey, descKeys, state ? enabled : disabled);
    }

    public static List<class_2561> buildToggleComponentsList(String titleKey, List<String> descKeys, class_2561 state) {
        ArrayList<class_2561> ret = new ArrayList<class_2561>();
        ret.add((class_2561)class_2561.method_43471((String)titleKey).method_27692(class_124.field_1068));
        if (descKeys != null) {
            for (String descKey : descKeys) {
                ret.add((class_2561)class_2561.method_43473().method_10852(DESC_ARROW).method_10852((class_2561)class_2561.method_43471((String)descKey).method_27692(class_124.field_1080)));
            }
        }
        ret.add(state);
        return ret;
    }

    public static class_2561 buildTooltip(List<class_2561> components) {
        if (components.isEmpty()) {
            return class_2561.method_43473();
        }
        Iterator<class_2561> iterator = components.iterator();
        class_5250 ret = class_2561.method_43473().method_10852(iterator.next());
        while (iterator.hasNext()) {
            ret = ret.method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852(iterator.next());
        }
        return ret;
    }

    public static class_5250 coloredComponent(class_5250 start, int color) {
        return start.method_27696(start.method_10866().method_36139(color));
    }

    public static class_5250 setColor(class_5250 component, int color) {
        return component.method_27696(component.method_10866().method_36139(color));
    }

    public static class_2561 getDistance(class_2338 playerPos, class_2338 targetPos) {
        return class_2561.method_43470((String)String.valueOf((int)Math.sqrt(playerPos.method_10262((class_2382)targetPos)))).method_27692(class_124.field_1080);
    }

    public static class_2561 getLocationObjectTargetName(ILocationObject object) {
        int softColor;
        boolean priority = object.priority();
        int defaultColor = priority ? 13939050 : 0xAAAAAA;
        int n = softColor = priority ? 16176273 : 0xC8C8C8;
        if (object instanceof WithContent) {
            WithContent withContent = (WithContent)((Object)object);
            class_5250 ret = class_2561.method_43473();
            ret.method_10852((class_2561)ClientUtils.coloredComponent(class_2561.method_43471((String)object.descriptionId()), defaultColor));
            ret.method_10852((class_2561)ClientUtils.coloredComponent(class_2561.method_43470((String)" ["), defaultColor));
            ret.method_10852((class_2561)ClientUtils.coloredComponent(class_2561.method_43471((String)withContent.contentId()), softColor));
            ret.method_10852((class_2561)ClientUtils.coloredComponent(class_2561.method_43470((String)"]"), defaultColor));
            return ret;
        }
        return ClientUtils.coloredComponent(class_2561.method_43471((String)object.descriptionId()), defaultColor);
    }

    public static class_2561 cutComponent(class_327 font, class_2561 component, int availableWidth) {
        class_5250 ret = class_2561.method_43473();
        class_5250 dots = class_2561.method_43470((String)"...");
        int dotsWidth = font.method_27525((class_5348)dots);
        if (availableWidth <= font.method_27525((class_5348)dots)) {
            return dots;
        }
        int componentWidth = font.method_27525((class_5348)component);
        if (componentWidth <= availableWidth) {
            return component;
        }
        int widthUsed = 0;
        for (class_2561 content : component.method_44746()) {
            int contentWidth = font.method_27525((class_5348)content);
            if (widthUsed + contentWidth + dotsWidth <= availableWidth) {
                ret.method_10852(content);
                widthUsed += contentWidth;
                continue;
            }
            String s = content.getString();
            if (widthUsed + dotsWidth >= availableWidth) {
                ret.method_10852((class_2561)dots.method_27696(content.method_10866()));
                break;
            }
            class_5250 formated = class_2561.method_43470((String)font.method_27523(s, availableWidth - widthUsed - dotsWidth)).method_27696(content.method_10866()).method_10852((class_2561)dots.method_27696(content.method_10866()));
            ret.method_10852((class_2561)formated);
            break;
        }
        return ret;
    }

    public static String compressNumber(int val) {
        int abs = Math.abs(val);
        if (abs >= 1000000) {
            return val / 1000000 + class_2561.method_43471((String)"hud.travelerscompass.number.mega").getString();
        }
        if (abs >= 1000) {
            return val / 1000 + class_2561.method_43471((String)"hud.travelerscompass.number.kilo").getString();
        }
        return String.valueOf(val);
    }

    public static class_2561 formatReason(FilterReason reason) {
        if (reason instanceof FilterReason.ByModId) {
            FilterReason.ByModId byMod = (FilterReason.ByModId)reason;
            return class_2561.method_43469((String)"tooltip.travelerscompass.config.filter_reason.mod", (Object[])new Object[]{Platform.PLATFORM.getModName(byMod.modId())}).method_27692(class_124.field_1061);
        }
        if (reason instanceof FilterReason.ByItemId) {
            return class_2561.method_43471((String)"tooltip.travelerscompass.config.filter_reason.item").method_27692(class_124.field_1061);
        }
        if (reason instanceof FilterReason.ByTag) {
            FilterReason.ByTag byTag = (FilterReason.ByTag)reason;
            return class_2561.method_43469((String)"tooltip.travelerscompass.config.filter_reason.tag", (Object[])new Object[]{byTag.tag().comp_327().toString()}).method_27692(class_124.field_1061);
        }
        if (reason instanceof FilterReason.ByEntityType) {
            FilterReason.ByEntityType byEntityType = (FilterReason.ByEntityType)reason;
            class_2561 entityName = byEntityType.type().method_5897();
            return class_2561.method_43469((String)"tooltip.travelerscompass.config.filter_reason.entity", (Object[])new Object[]{entityName}).method_27692(class_124.field_1061);
        }
        return class_2561.method_43473();
    }

    public static void renderTexture(class_332 graphics, IconTexture iconTexture, int x, int y) {
        ClientUtils.renderTexture(graphics, iconTexture.textureData(), x + iconTexture.xOffset(), y + iconTexture.yOffset());
    }

    public static void renderTexture(class_332 graphics, TextureData data, int x, int y) {
        graphics.method_25293(data.getLocation(), x, y, data.getRenderWidth(), data.getRenderHeight(), (float)data.getU(), (float)data.getV(), data.getWidth(), data.getHeight(), data.getTextureWidth(), data.getTextureHeight());
    }
}

