/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.utils;

import com.nine.travelerscompass.client.utils.IconTexture;
import net.minecraft.class_2960;

public class TextureData {
    private final int u;
    private final int v;
    private final int width;
    private final int height;
    private final int textureWidth;
    private final int textureHeight;
    private final int renderWidth;
    private final int renderHeight;
    private final class_2960 location;

    public TextureData(class_2960 location, int u, int v, int width, int height, int renderWidth, int renderHeight, int textureWidth, int textureHeight) {
        this.location = location;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.renderWidth = renderWidth;
        this.renderHeight = renderHeight;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public int getV() {
        return this.v;
    }

    public int getU() {
        return this.u;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public int getRenderWidth() {
        return this.renderWidth;
    }

    public int getRenderHeight() {
        return this.renderHeight;
    }

    public class_2960 getLocation() {
        return this.location;
    }

    public IconTexture icon(int x, int y) {
        return new IconTexture(this, x, y);
    }

    public static class Builder {
        private class_2960 location;
        private int u = 0;
        private int v = 0;
        private int textureWidth = 0;
        private int textureHeight = 0;
        private int width;
        private int height;
        private int renderWidth;
        private int renderHeight;
        private static final String GUI_TEXTURES_PATH = "textures/gui/";

        public Builder location(String path) {
            this.location = class_2960.method_60655((String)"travelerscompass", (String)(GUI_TEXTURES_PATH + path + ".png"));
            return this;
        }

        public Builder uv(int u, int v) {
            this.u = u;
            this.v = v;
            return this;
        }

        public Builder renderSize(int size) {
            return this.renderSize(size, size);
        }

        public Builder renderSize(int width, int height) {
            this.renderWidth = width;
            this.renderHeight = height;
            return this;
        }

        public Builder size(int size) {
            return this.size(size, size);
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder sourceSize(int width, int height) {
            this.textureWidth = width;
            this.textureHeight = height;
            return this;
        }

        public Builder from(TextureData data) {
            this.location = data.location;
            this.u = data.u;
            this.v = data.v;
            this.width = data.width;
            this.height = data.height;
            this.renderWidth = data.renderWidth;
            this.renderHeight = data.renderHeight;
            this.textureWidth = data.textureWidth;
            this.textureHeight = data.textureHeight;
            return this;
        }

        public TextureData build() {
            if (this.renderWidth == 0) {
                this.renderWidth = this.width;
            }
            if (this.renderHeight == 0) {
                this.renderHeight = this.height;
            }
            if (this.textureWidth == 0) {
                this.textureWidth = this.width;
            }
            if (this.textureHeight == 0) {
                this.textureHeight = this.height;
            }
            return new TextureData(this.location, this.u, this.v, this.width, this.height, this.renderWidth, this.renderHeight, this.textureWidth, this.textureHeight);
        }
    }
}

