/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.data;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.init.RegistryProvider;
import com.nine.travelerscompass.network.packet.c2s.CompassDataPacket;
import com.nine.travelerscompass.platform.Platform;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_9331;

public class DataStorage<T> {
    private final String id;
    private final byte networkId;
    private final Supplier<T> defaultSupplier;
    private final Function<T, T> validator;
    private final RegistryProvider<class_9331<T>> componentProvider;

    public DataStorage(String id, byte networkId, Supplier<T> defaultSupplier, Function<T, T> validator, RegistryProvider<class_9331<T>> componentProvider) {
        this.id = id;
        this.networkId = networkId;
        this.defaultSupplier = defaultSupplier;
        this.validator = validator;
        this.componentProvider = componentProvider;
    }

    public class_9331<T> dataComponent() {
        return (class_9331)this.componentProvider.get();
    }

    public String id() {
        return this.id;
    }

    public byte networkId() {
        return this.networkId;
    }

    public T get(class_1799 stack) {
        return (T)(stack.method_57826(this.dataComponent()) ? stack.method_57824(this.dataComponent()) : this.defaultValue());
    }

    public T defaultValue() {
        return this.defaultSupplier.get();
    }

    private T validate(T value) {
        return this.validator.apply(value);
    }

    public void set(class_1799 stack, T value) {
        stack.method_57379(this.dataComponent(), this.validate(value));
    }

    public void sendToServer(class_1799 stack, T value) {
        this.set(stack, value);
        UUID compassUUID = CompassProperties.COMPASS_UUID.get(stack);
        Platform.PLATFORM_NETWORK.sendToServer(new CompassDataPacket<T>(compassUUID, this, value));
    }
}

