/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public class SearchOptions {
    private final Map<DataStorage<?>, Object> options = new HashMap();
    private final int entitiesSearchRange;
    private final int chunksSearchRange;
    private final boolean wideSearch;
    private final UUID playerUUID;
    private final class_3222 player;

    public SearchOptions(class_1799 stack, class_3222 player, boolean wideSearch) {
        for (DataStorage<?> property : CompassProperties.SEARCH_OPTIONS) {
            this.options.put(property, CompassProperties.get(stack, property));
        }
        this.entitiesSearchRange = CompassProperties.ENTITIES_SEARCH_RANGE.get(stack);
        this.chunksSearchRange = wideSearch ? CompassProperties.WIDE_SEARCH_RANGE.get(stack) : CompassProperties.BLOCK_SEARCH_CHUNK_RANGE.get(stack);
        this.playerUUID = player.method_5667();
        this.player = player;
        this.wideSearch = wideSearch;
    }

    public int getEntitiesSearchRange() {
        return this.entitiesSearchRange;
    }

    public int getChunksSearchRange() {
        return this.chunksSearchRange;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public class_3222 player() {
        return this.player;
    }

    public boolean wideSearch() {
        return this.wideSearch;
    }

    public <T> T get(DataStorage<T> option) {
        return (T)this.options.get(option);
    }
}

