/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.location;

import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithContent;
import com.nine.travelerscompass.common.search.location.WithUUID;
import com.nine.travelerscompass.common.search.location.codec.LocationCodec;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public record LootrMinecartLocationObject(class_2338 blockPos, int slotIndex, boolean priority, String descriptionId, String contentId, UUID uuid) implements ILocationObject,
WithContent,
WithUUID
{
    public static class_2960 TYPE = class_2960.method_60655((String)"travelerscompass", (String)"lootr_minecart_location_codec");
    public static final LocationCodec<LootrMinecartLocationObject> CODEC = new LocationCodec<LootrMinecartLocationObject>(){

        @Override
        public void write(class_2540 buf, LootrMinecartLocationObject obj) {
            this.writePosSafe(buf, obj.blockPos);
            buf.method_53002(obj.slotIndex);
            buf.method_52964(obj.priority);
            buf.method_10814(obj.descriptionId);
            buf.method_10814(obj.contentId);
            buf.method_10797(obj.uuid);
        }

        @Override
        public LootrMinecartLocationObject read(class_2540 buf) {
            class_2338 blockPos = this.readPosSafe(buf);
            int slotIndex = buf.readInt();
            boolean priority = buf.readBoolean();
            String descriptionId = buf.method_19772();
            String contentId = buf.method_19772();
            UUID uuid = buf.method_10790();
            return new LootrMinecartLocationObject(blockPos, slotIndex, priority, descriptionId, contentId, uuid);
        }
    };

    @Override
    public class_2960 type() {
        return TYPE;
    }

    @Override
    public boolean isValid(class_3218 level) {
        return level.method_14190(this.uuid) != null;
    }

    @Override
    public ILocationObject copy(class_2338 blockPos, int slotIndex, boolean priority, String descriptionId) {
        return new LootrMinecartLocationObject(blockPos, slotIndex, priority, descriptionId, this.contentId, this.uuid);
    }

    @Override
    public Optional<ILocationObject> update(class_3218 level) {
        class_1297 entity = level.method_14190(this.uuid);
        if (entity != null && !entity.method_24515().equals((Object)this.blockPos)) {
            return Optional.of(new LootrMinecartLocationObject(entity.method_24515(), this.slotIndex, this.priority, this.descriptionId, this.contentId, this.uuid));
        }
        return Optional.of(this);
    }

    @Override
    public String toString() {
        return "Lootr Container Entity [" + this.descriptionId + ": " + this.contentId + "], " + String.valueOf(this.blockPos) + (this.priority ? " [priority]" : "");
    }
}

