/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.location;

import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithContent;
import com.nine.travelerscompass.common.search.location.codec.LocationCodec;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public record SpawnerLocationObject(class_2338 blockPos, int slotIndex, boolean priority, String descriptionId, String contentId, class_2960 blockId) implements ILocationObject,
WithContent
{
    public static class_2960 TYPE = class_2960.method_60655((String)"travelerscompass", (String)"spawner_location_codec");
    public static final LocationCodec<SpawnerLocationObject> CODEC = new LocationCodec<SpawnerLocationObject>(){

        @Override
        public void write(class_2540 buf, SpawnerLocationObject obj) {
            this.writePosSafe(buf, obj.blockPos);
            buf.method_53002(obj.slotIndex);
            buf.method_52964(obj.priority);
            buf.method_10814(obj.descriptionId);
            buf.method_10814(obj.contentId);
            buf.method_10812(obj.blockId);
        }

        @Override
        public SpawnerLocationObject read(class_2540 buf) {
            class_2338 blockPos = this.readPosSafe(buf);
            int slotIndex = buf.readInt();
            boolean priority = buf.readBoolean();
            String descriptionId = buf.method_19772();
            String containerId = buf.method_19772();
            class_2960 blockId = buf.method_10810();
            return new SpawnerLocationObject(blockPos, slotIndex, priority, descriptionId, containerId, blockId);
        }
    };

    @Override
    public class_2960 type() {
        return TYPE;
    }

    @Override
    public boolean isValid(class_3218 level) {
        boolean loaded = level.method_8477(this.blockPos);
        if (!loaded) {
            return true;
        }
        class_2248 block = level.method_8320(this.blockPos).method_26204();
        return ((class_2248)class_7923.field_41175.method_10223(this.blockId)).equals(block);
    }

    @Override
    public ILocationObject copy(class_2338 blockPos, int slotIndex, boolean priority, String descriptionId) {
        return new SpawnerLocationObject(blockPos, slotIndex, priority, descriptionId, this.contentId, this.blockId);
    }

    @Override
    public Optional<ILocationObject> update(class_3218 level) {
        return Optional.of(this);
    }

    @Override
    public String toString() {
        return "Spawner Location: [" + this.descriptionId + "--" + this.contentId + String.valueOf(this.blockPos) + (this.priority ? " [priority]" : "");
    }
}

