/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.matcher;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchOptions;
import com.nine.travelerscompass.common.search.criterion.BlockCriterion;
import com.nine.travelerscompass.common.search.criterion.EntityCriterion;
import com.nine.travelerscompass.common.search.criterion.FluidCriterion;
import com.nine.travelerscompass.common.search.criterion.ISearchCriterion;
import com.nine.travelerscompass.common.search.criterion.ItemCriterion;
import com.nine.travelerscompass.common.search.criterion.TypedCriteria;
import com.nine.travelerscompass.common.search.location.BlockLocationObject;
import com.nine.travelerscompass.common.search.location.ContainerEntityLocationObject;
import com.nine.travelerscompass.common.search.location.EntityLocationObject;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.SpawnerLocationObject;
import com.nine.travelerscompass.common.search.matcher.BlockEntityMatcher;
import com.nine.travelerscompass.common.search.matcher.BlockMatcher;
import com.nine.travelerscompass.common.search.matcher.EntityMatcher;
import com.nine.travelerscompass.common.utils.LootUtils;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.mixin.accessor.BaseSpawnerAccessor;
import com.nine.travelerscompass.mixin.accessor.LiquidBlockAccessor;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1693;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class PositionMatchers {
    public static final BlockMatcher BLOCK_MATCHER = new BlockMatcher(){

        @Override
        public ILocationObject match(TypedCriteria criteria, class_2338 pos, class_2680 state) {
            class_2248 block = state.method_26204();
            for (BlockCriterion criterion : criteria.blockCriteria) {
                if (!criterion.check(block)) continue;
                class_2960 id = class_7923.field_41175.method_10221((Object)block);
                return new BlockLocationObject(pos, criterion.slot(), criterion.priority(), block.method_9518().getString(), id);
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.BLOCKS) != false && TCConfig.ENABLE_BLOCKS_SEARCH.get() != false;
        }
    };
    public static final BlockMatcher FLUID_MATCHER = new BlockMatcher(){

        @Override
        public ILocationObject match(TypedCriteria criteria, class_2338 pos, class_2680 state) {
            class_2248 block = state.method_26204();
            if (block instanceof class_2404) {
                class_2404 liquidBlock = (class_2404)block;
                class_3611 fluid = ((LiquidBlockAccessor)liquidBlock).travelerscompass$getFluidState(state).method_15772();
                for (FluidCriterion criterion : criteria.fluidCriteria) {
                    if (!criterion.check(fluid)) continue;
                    class_2960 id = class_7923.field_41175.method_10221((Object)block);
                    return new BlockLocationObject(pos.method_10062(), criterion.slot(), criterion.priority(), state.method_26204().method_9539(), id);
                }
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.FLUIDS) != false && TCConfig.ENABLE_FLUIDS_SEARCH.get() != false;
        }
    };
    public static final BlockEntityMatcher SPAWNER_MATCHER = new BlockEntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, class_2338 pos, class_2680 state, class_2586 be) {
            class_2487 compoundtag;
            Optional optional;
            class_2636 spawnerBlockEntity;
            class_1952 spawndata;
            class_2248 block = state.method_26204();
            if (be instanceof class_2636 && (spawndata = ((BaseSpawnerAccessor)(spawnerBlockEntity = (class_2636)be).method_11390()).travelerscompass$nextSpawnData()) != null && (optional = class_1299.method_17684((class_2487)(compoundtag = spawndata.method_38093()))).isPresent()) {
                class_1299 entityType = (class_1299)optional.get();
                for (EntityCriterion criterion : criteria.entityCriteria) {
                    if (!criterion.check(entityType)) continue;
                    class_2960 id = class_7923.field_41175.method_10221((Object)block);
                    return List.of(new SpawnerLocationObject(pos.method_10062(), criterion.slot(), criterion.priority(), state.method_26204().method_9539(), entityType.method_5882(), id));
                }
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.SPAWNERS) != false && TCConfig.ENABLE_SPAWNERS_SEARCH.get() != false;
        }
    };
    public static final EntityMatcher MINECART_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, class_1297 entity, class_1937 level, class_2338 pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof class_1693) {
                class_1693 minecart = (class_1693)entity;
                if (criteria.itemCriteria.isEmpty()) {
                    return List.of();
                }
                UUID uuid = minecart.method_5667();
                String descriptionId = entity.method_5864().method_5882();
                for (class_1799 stack : minecart.method_42278()) {
                    class_1792 item = stack.method_7909();
                    if (!criteria.itemCriteriaMap.containsKey(item)) continue;
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new ContainerEntityLocationObject(pos.method_10062(), criterion.slot(), criterion.priority(), descriptionId, item.method_7876(), uuid));
                }
            }
            return ret;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            if (!options.get(CompassProperties.CONTAINERS).booleanValue() || !TCConfig.ENABLE_BLOCK_CONTAINERS_SEARCH.get().booleanValue()) {
                return false;
            }
            return options.get(CompassProperties.MINECARTS);
        }
    };
    public static final EntityMatcher EGG_MOB_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, class_1297 entity, class_1937 level, class_2338 pos) {
            class_1299 type = entity.method_5864();
            for (EntityCriterion criterion : criteria.entityCriteria) {
                if (!criterion.check(type)) continue;
                return List.of(new EntityLocationObject(entity.method_24515(), criterion.slot(), criterion.priority(), entity.method_5477().getString(), entity.method_5667()));
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.MOBS) != false && TCConfig.ENABLE_MOBS_SEARCH.get() != false;
        }
    };
    public static final EntityMatcher VILLAGER_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, class_1297 entity, class_1937 level, class_2338 pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof class_1646) {
                class_1646 villager = (class_1646)entity;
                class_1916 offers = villager.method_8264();
                boolean buys = options.get(CompassProperties.VILLAGERS_BUYS);
                boolean sells = options.get(CompassProperties.VILLAGERS_SELLS);
                UUID uuid = villager.method_5667();
                String descriptionId = entity.method_5864().method_5882();
                for (class_1914 offer : offers) {
                    class_1792 resultItem = offer.method_8250().method_7909();
                    class_1792 costAItem = offer.method_19272().method_7909();
                    class_1792 costBItem = offer.method_8247().method_7909();
                    for (ItemCriterion criterion : criteria.itemCriteria) {
                        if (sells && criterion.check(resultItem)) {
                            ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), descriptionId, resultItem.method_7876(), uuid));
                        }
                        if (!buys) continue;
                        if (criterion.check(costAItem)) {
                            ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), descriptionId, costAItem.method_7876(), uuid));
                        }
                        if (!criterion.check(costBItem)) continue;
                        ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), descriptionId, costBItem.method_7876(), uuid));
                    }
                }
                return ret;
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.VILLAGERS) != false && (options.get(CompassProperties.VILLAGERS_BUYS) != false || options.get(CompassProperties.VILLAGERS_SELLS) != false) && TCConfig.ENABLE_VILLAGERS_SEARCH.get() != false;
        }
    };
    public static final EntityMatcher INVENTORY_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, class_1297 entity, class_1937 level, class_2338 pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                HashSet<class_1792> invItems = new HashSet<class_1792>();
                boolean players = options.get(CompassProperties.INVENTORIES_PLAYERS);
                boolean mobs = options.get(CompassProperties.INVENTORIES_MOBS);
                String descriptionId = entity.method_5864().method_5882();
                UUID uuid = entity.method_5667();
                if (uuid.equals(options.getPlayerUUID())) {
                    return null;
                }
                if (living instanceof class_1657) {
                    class_1657 player = (class_1657)living;
                    if (players) {
                        invItems.addAll(player.method_31548().field_7547.stream().map(class_1799::method_7909).toList());
                        invItems.addAll(player.method_31548().field_7548.stream().map(class_1799::method_7909).toList());
                        invItems.addAll(player.method_31548().field_7544.stream().map(class_1799::method_7909).toList());
                        descriptionId = player.method_5476().getString();
                    }
                } else if (mobs) {
                    for (class_1304 slot : class_1304.values()) {
                        invItems.add(living.method_6118(slot).method_7909());
                    }
                } else {
                    return null;
                }
                for (ItemCriterion criterion : criteria.itemCriteria) {
                    if (!invItems.contains(criterion.item())) continue;
                    ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), descriptionId, criterion.item().method_7876(), uuid));
                }
                return ret;
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.INVENTORIES) != false && (options.get(CompassProperties.INVENTORIES_MOBS) != false || options.get(CompassProperties.INVENTORIES_PLAYERS) != false);
        }
    };
    public static final EntityMatcher DROP_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, class_1297 entity, class_1937 level, class_2338 pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof class_1309) {
                Set<class_1792> drops;
                class_1309 living = (class_1309)entity;
                MinecraftServer server = level.method_8503();
                if (server != null && (drops = LootUtils.getItemsFromLootTable((class_5321<class_52>)living.method_5989(), level)) != null) {
                    for (ItemCriterion criterion : criteria.itemCriteria) {
                        if (!drops.contains(criterion.item())) continue;
                        ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), entity.method_5864().method_5882(), criterion.item().method_7876(), entity.method_5667()));
                    }
                }
                return ret;
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.DROP);
        }
    };
    public static final EntityMatcher ITEM_ENTITY_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, class_1297 entity, class_1937 level, class_2338 pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                if (criteria.itemCriteria.isEmpty()) {
                    return ret;
                }
                class_1792 item = itemEntity.method_6983().method_7909();
                if (criteria.itemCriteriaMap.containsKey(item)) {
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new EntityLocationObject(pos.method_10062(), criterion.slot(), criterion.priority(), item.method_7876(), itemEntity.method_5667()));
                }
                return ret;
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.ITEM_ENTITIES);
        }
    };
    public static final List<BlockMatcher> BLOCK_MATCHERS = new ArrayList<BlockMatcher>(List.of(BLOCK_MATCHER, FLUID_MATCHER));
    public static final List<BlockEntityMatcher> BLOCK_ENTITY_MATCHERS = new ArrayList<BlockEntityMatcher>(List.of(SPAWNER_MATCHER));
    public static final List<EntityMatcher> ENTITY_MATCHERS = new ArrayList<EntityMatcher>(List.of(EGG_MOB_MATCHER, INVENTORY_MATCHER, MINECART_MATCHER, VILLAGER_MATCHER, DROP_MATCHER, ITEM_ENTITY_MATCHER));

    static {
        BLOCK_MATCHERS.addAll(Platform.PLATFORM_MATCHERS.blockMatchers());
        BLOCK_ENTITY_MATCHERS.addAll(Platform.PLATFORM_MATCHERS.blockEntityMatchers());
        ENTITY_MATCHERS.addAll(Platform.PLATFORM_MATCHERS.entityMatchers());
    }
}

