/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.nine.travelerscompass.common.utils.HudType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class HudSize {
    public static final Codec<HudSize> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("values").forGetter(HudSize::values)).apply((Applicative)instance, HudSize::new));
    public static final class_9139<ByteBuf, HudSize> STREAM_CODEC = class_9139.method_56434((class_9139)class_9135.field_49675.method_56433(class_9135.method_56363()), HudSize::values, HudSize::new);
    private final List<Integer> values;

    public HudSize() {
        ArrayList<Integer> tmp = new ArrayList<Integer>(HudType.values().length * 2);
        for (HudType type : HudType.values()) {
            tmp.add(type.defaultWidth());
            tmp.add(type.defaultHeight());
        }
        this.values = List.copyOf(tmp);
    }

    public HudSize(List<Integer> values) {
        this.values = values;
    }

    public List<Integer> values() {
        return this.values;
    }

    public HudSize withWidth(HudType type, int value) {
        ArrayList<Integer> ret = new ArrayList<Integer>(this.values);
        ret.set(type.ordinal() * 2, value);
        return new HudSize(ret);
    }

    public HudSize withHeight(HudType type, int value) {
        ArrayList<Integer> ret = new ArrayList<Integer>(this.values);
        ret.set(type.ordinal() * 2 + 1, value);
        return new HudSize(ret);
    }

    public int getWidth(HudType type) {
        return this.values.get(type.ordinal() * 2);
    }

    public int getHeight(HudType type) {
        return this.values.get(type.ordinal() * 2 + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HudSize)) {
            return false;
        }
        HudSize other = (HudSize)o;
        return this.values.equals(other.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }
}

